# centroidpeaks.cl -> finds peaks and uses a centroiding algorithm to 
# accurately locate them
#
# AJD 13/11/0

procedure centroidpeaks(name,in_outfile,in_line,in_noise,in_sigma,in_minsep,in_width,in_review)

string name {prompt="Name of calibration fibre image"}
string in_outfile {prompt="Name of file to contain the output fibre positions"}
bool overw     {mode="l", prompt="overwrite output file?"}
int in_line    {prompt="Line to use as cut through image"}
int in_noise   {prompt="background noise in image"}
int in_sigma   {prompt="sigma above background which indicates a line"}
int in_minsep  {prompt="Minimum separation between fibres"}
int in_width   {prompt="How far either side of peak to look when centroiding"}
bool in_review {prompt="View the peaks found?"}

struct *in {mode="h"}

begin

string p_name, p_outfile, tempfile, tempfile1, logfile, tempstr
string outfile, tempim
struct tempstruct
real junk, y, r1, r2, fwhmreal 
int i, num, p_initpos, j
int line,noise,sigma,minsep,len,width,medwidth
bool exist, over, review

real avshift
real fibpos[200]
real ypos[200]
real pos[508]
real fwhm[200]
real yrel[508]
real centre

p_name=name
outfile=in_outfile

# check if file already exists
exist=access(outfile)
if(exist){
		print("!!!!! output file exists !!!!!")
		over=overw
		if(over){ 
	  		delete(outfile)
		} else {
			print("You should probably pick a different name!")
		

		}
	}

line=in_line  
noise=in_noise  
sigma=in_sigma  
minsep=in_minsep
width=in_width
review=in_review
medwidth=11

##load required packages
utils

tempfile=mktemp("temp")
#tempfile1=mktemp("temp")
#logfile=mktemp("log")

# check for .fits on the end

        len=strlen(p_name)
        if(substr(p_name,len-4,len)!=".fits") {
                p_name=p_name//".fits"
        }

print("Locating the peaks using peakfind_sep")
peakfind_sep(p_name,line,noise,sigma,tempfile,minsep)

#fitprofs just needs the y coordinate so get this out of tempfile and
#put into tempfile1
in=tempfile
i=1
#while(fscan(in,junk,y,junk,junk)!=EOF){
while(fscan(in,y)!=EOF){
  ypos[i]=y
#  print("i ",i,"found at position ",ypos[i])
  i+=1
  if(i>=200){
	error(11,"Run out of room in fibre position array!")
  }
}

num=i-1

print("Accurately locating the lines by centroiding")

centre=0

#fit gaussians for each marked position. have to do this for each one 
#separately as sometimes it doesn't work if try to fit them all
#at the same time
for(i=1;i<=num;i+=1){
 
	peakcentre(p_name, line, ypos[i],width,medwidth) | scan(centre)
	fibpos[i]=centre


# tempfile1=mktemp("temp")
#  logfile=mktemp("log")
#  print(ypos[i],>tempfile1)
#  r1=ypos[i]-10
#  r2=ypos[i]+10
#  tempstr=r1//" "//r2
# print("position ",ypos[i]," region ",tempstr) 
#  fitprofs (p_name//"[sci,1]", lines=line, bands="", dispaxis=2, nsum="10", region=tempstr, positions=tempfile1, background="", profile="gaussian", gfwhm=2., lfwhm=2., fitbackgroun=yes, fitpositions="all", fitgfwhm="all", fitlfwhm="all", nerrsample=0, sigma0=INDEF, invgain=INDEF, components="", verbose=no, logfile=logfile, plotfile="", output="", option="fit", clobber=no, merge=no)
#  delete(tempfile1)

#pull out the centre positions which is the first column in logfile
#and put into array fibpos
#  in=logfile
#  while(fscan(in,tempstr,junk,junk,junk,junk,fwhmreal)!=EOF){
#    if(tempstr!="#"){
#      fibpos[i]=real(tempstr)
#      fwhm[i]=fwhmreal
#    }
#  }
#  delete(logfile)

}

#Output the results

for(i=1;i<=num;i+=1){
  print("found at ", ypos[i], "centered at ",fibpos[i])
  print(fibpos[i]," 1.0",>>outfile)
}

if(review){
	tempim=mktemp("__temp__")
	imcopy(p_name//"[sci,1]["//line//",*]",tempim)
	specmark_no_wav(tempim//".fits",outfile)
	imdel(tempim)
}

delete(tempfile)

end






