# follow1.cl 
#
# Follows 1 fibre trace across an image
#
# AJD 12/11/01

procedure follow1(name,in_outfile,in_line, in_linef,in_width)

string name {prompt="Name of calibration fibre image"}
string in_outfile {prompt="Name of file to contain trace information"}
bool overw     {mode="l", prompt="overwrite output file?"}
int in_line    {prompt="y value to follow trace at"}
string in_linef{prompt="Name of file containing lines to use to obtain trace"}
int in_width   {prompt="max area around fibre to search for peak"}

struct *in {mode="h"}

begin

string p_name, p_outfile, tempfile, tempfile1, logfile, tempstr, tempfile2
string outfile, tempim, datatofit
string linef, reffile
int linearray[50]
int line, tempdata
int numlines, width
struct tempstruct
real junk, y, r1, r2, fwhmreal 
int i, num, p_initpos, j
int  sigma,minsep,len, p_frame
bool exist, over, review

real fibpos[200]

p_name=name
outfile=in_outfile

# check if file already exists
exist=access(outfile)
if(exist){
		print("!!!!! output file exists !!!!!")
		over=overw
		if(over){ 
	  		delete(outfile)
		} else {
			print("You should probably pick a different name!")
		

		}
	}

line=in_line
linef=in_linef  
width=in_width

##load required packages
utils

# read in the lines to check
i=1
in=linef
while(fscan(in,tempdata)!=EOF){
	linearray[i]=tempdata
#	print("got data ",linearray[i])
	i+=1
	if(i>=50){
		error(10,"Array for lines run out of room!")
	}
}

numlines=i-1

# check for .fits on the end of input image file

        len=strlen(p_name)
        if(substr(p_name,len-4,len)!=".fits") {
                p_name=p_name//".fits"
        }

#Use the middleish line in peakfind

#fit gaussians for each marked position. have to do this for each one 
#separately as sometimes it doesn't work if try to fit them all
#at the same time
for(i=1;i<=numlines;i+=1){
  tempfile1=mktemp("temp")
  logfile=mktemp("log")
  print(line,>tempfile1)
  r1=line-width
  r2=line+width
  tempstr=r1//" "//r2
# print("position ",line," region ",tempstr) 
  fitprofs (p_name//"[sci,1]", lines=linearray[i], bands="", dispaxis=2, nsum="10", region=tempstr, positions=tempfile1, background="", profile="gaussian", gfwhm=2., lfwhm=2., fitbackgroun=yes, fitpositions="all", fitgfwhm="all", fitlfwhm="all", nerrsample=0, sigma0=INDEF, invgain=INDEF, components="", verbose=no, logfile=logfile, plotfile="", output="", option="fit", clobber=no, merge=no)
  delete(tempfile1)

#pull out the centre positions which is the first column in logfile
#and put into array fibpos
  in=logfile
  while(fscan(in,tempstr,junk,junk,junk,junk,fwhmreal)!=EOF){
    if(tempstr!="#"){
      fibpos[i]=real(tempstr)
    }
  }
  delete(logfile)
}

#Output the results

for(i=1; i<=numlines; i+=1){
	print(linearray[i], fibpos[i], >> outfile) 
}

end
