#include <stdio.h> /* Standard Input/ Output Library */
#include <stdlib.h>
#include "extract_float.h"
#include "fitswrap.h"


/*this program to write out a simulated CIRPASS image. was doing this
  with IRAF mk2dspec routine, but I don't think that is accurate enough*/

int main ()
{
  /*  extern int IMSIZE;
      extern int 508;*/
  float *phi[508];
  float data[1024]={0};
  float peakpos[508];
  float fibval[508];
  float fibpars[508*7];
  char* exts[]={"SCI"};
  char outfile[255];
  char filename[255];
  char templfile[255];
  int numpk, numval, i, j, k, type;
  int naxis=2;
  int nval,polyorder;
  long naxes[]={1024,1024};
  float *outdata[1];
 
  outdata[0] = (float*) malloc((sizeof(float))*1024*1024);

  for(i=0;i<508;i++){
    phi[i]=(float*)malloc(1024*sizeof(float));
  }

  printf("what is the name for the output FITS image?\n");
  scanf("%s",outfile);

  /*template file for header and table extension*/
  sprintf(templfile,"templ.fits");

  /*read coordinates of peaks at pixel=1024 from file. put into
    array peakposinit*/

  printf("which file contains coordinates of spectra peaks and curvature?\n");
  scanf("%s",filename);
  numpk = getval2(filename, fibpars);
  polyorder=*(fibpars+2);  
  nval=3+polyorder;
  /*  for(j=0;j<508;j++){
    printf("peakpos %g\n",*(fibpars + j*nval));
    }*/
  numpk=numpk/nval;
  printf("numpk %d\n",numpk);

  /*read sum in each fibre from file */
  printf("which file contains value of each spectrum\n");
  scanf("%s",filename);
  numval = getval1(filename,fibval,numpk);

  /*for(i=0;i<numpk;i++){
    printf("fibval %g\n",fibval[i]);
    }*/

  /*loop over wv-pixels, as now writing curved spectra so peak position
    changes with wavelength*/

  printf("getting output data\n");
  for(i=0;i<1024;i++){

    /*initialize data array*/
    for(j=0;j<1024;j++){
      data[j]=0;
    }

    type=gettype();
    /*    printf("type %d\n",type);*/

    /*get peakpos values at this wavelength.
      CHANGE for now just assuming no curvature*/
    
    for(j=0;j<numpk;j++){
      peakpos[j]=*(fibpars + j*nval);
    }
    

    /*get phi values.*/
    getphi(peakpos, numpk, 1024, type, phi);

    /*work out data value at each pixel row i column k*/

    /*printf("working out data values\n");*/
    for(k=0;k<1024;k++){
      for(j=0;j<numpk;j++){
      /*      if((j>521)&&(j<530)){
	printf("i %d j %d data %g\n",i,j,data[j]);
	}*/
	data[k]+=phi[j][k]*fibval[j];
      /*
      if((j>521)&&(j<530)){
	printf("i %d j %d phi %g fibval %g data %g\n",i,j,phi[i][j],fibval[i],data[j]);
	}*/
      }
      /*      if(i==0){
	      printf("k %d data %g\n",k,data[k]);
	      }*/
      
      outdata[0][k*1024+i]=data[k];    
    }
  }
  
  /*write out data to FITS file*/
  printf("writing output FITS file\n");
  write_cirp_copy_hdu_float(templfile,outfile,exts,outdata,1,naxis,naxes);

  for(i=0;i<508;i++){
    free(phi[i]);
  }


  free(outdata[0]);
    

  return 0;
}
