/* mkerr.c driver exectuable for mkerror.c 
 *
 * AJ Dean. 1st Aug, 2000
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mkerror.h"
#include "fitswrap.h"

int main(int argc, char* argv[])
{

  float* readnoise=NULL;    /* array for the readnoise */
  float* gain=NULL;         /* array for the gain values */
  float* data=NULL;         /* array for the input science data in DN */
  float* error=NULL;        /* array for the calculated errors output in DN */

  float readval=0;            /* readnoise if just given a number not image */
  float gainval=0;            /* gain if just given a number not image */

  long nx=0;                  /* image dimensions */
  long ny=0;
  long arraysize=0;           /* nx * ny i.e. size of image array */
  int nextend=0;              /* total number of extensions in input file */
  int nerr=0;                 /* number of error extensions in input file */

  int i=0;                    /* loop variable */

  /* check for appropriate input */
  if (argc < 4) {
    fprintf(stderr, 
            "Usage: %s scidata.fits [readnoise.fits|(float)readnoise e-] [gain.fits|(float)gain e-/DN] \n", 
            argv[0]);
    exit(1);
  }

  /* Read in the data */

  data=read_ME_FITS(argv[1], "sci", &nx, &ny, &nextend);

  arraysize=nx*ny;
  nerr=nextend/NIMSET;

  /* Find out how we were called */

  if ( strstr (argv[2], ".fits" ) == NULL &&  
       strstr (argv[2], ".FITS" ) == NULL )
    
    {
      
      /* No .fits i.e. we were given a number */

      sscanf(argv[2],"%f",&readval);
      
      printf("mkerr: Using a readnoise of %f electrons\n",readval);
      
      if ( (readnoise=(float *)malloc(arraysize*sizeof(float))) == NULL ){

	printf("mkerr: Memory allocation for readnoise array failed!");
	exit(1);
      }

      for( i=0; i<arraysize; i++)
	*(readnoise+i)=readval;
      

    } else {

      /* Got an image array so read in the data */

      readnoise=readfits_float(argv[2],0);
    
    }
  
  if ( strstr (argv[3], ".fits" ) == NULL &&  
       strstr (argv[3], ".FITS" ) == NULL )
    
    {
      
      /* No .fits i.e. we were given a number */
      
      sscanf(argv[3],"%f",&gainval);
      
      printf("mkerr: Using a gain of %f electrons / data number\n",gainval);
      
      if ( (gain=(float *)malloc(arraysize*sizeof(float))) == NULL ){

	printf("mkerr: Memory allocation for gain array failed!");
	exit(1);
	}
      
      for( i=0; i<arraysize; i++)
	*(gain+i)=gainval;
      

    } else {

      /* Got an image array so read in the data */

      gain=readfits_float(argv[3],0);
    
    }
  
  /* Allocate memory for the error arrays */

  if ( (error=(float *)malloc(nerr*arraysize*sizeof(float))) == NULL ){

    printf("mkerr: Memory allocation for error array failed!");
    exit(1);
  }

  /* Calculate the error arrays */

  for( i=0; i<nerr; i++)

    mkerror( (data+i*arraysize), readnoise, gain, (error+i*arraysize), 
	     arraysize);

  /* Write out the data */

  write_ME_FITS_type(argv[1], "VAR", error, &nx, &ny, nerr);

  /* free the allocated memory */

  free(readnoise);
  free(gain);
  free(data);
  free(error);

  return 0;

}
  








