/* center.c 
**
** Quick driver for centroid in the maths utils
**
** A. J. Dean. 12th Nov, 2001
**
*/

#include <stdio.h>
#include <stdlib.h>
#include "fitswrap.h"
#include "mathutils.h"

int main(int argc, char* argv[]){

  float line=0;
  long axes[2]={0};
  float* data=NULL;
  int scanwidth=0;
  float* outdata=NULL;
  float* tempval=NULL;
  float* temppos=NULL;
  int ymin=0;
  int ymax=0;
  int over=0;
  int numdata=0;

  int i=0;
  int j=0;

  if (argc < 4) {
    
    fprintf(stderr, 
	    "Usage: %s image_file line scan(half)width\n", 
           argv[0]);
    exit(1);
  
  } 
 
  sscanf(argv[2],"%f",&line); 
  sscanf(argv[3],"%i",&scanwidth);

  /* Scan in y direction */
  ymin=line-scanwidth;
  ymax=line+scanwidth;
  numdata=(2*scanwidth)+1;

  /* Open image file */
  data=readfits_float_clever(argv[1], axes);

  if( ymin<0 ){
    printf("Requested line and scan width takes you outside range of detector!!\nSetting this to edge of detector\n");
    ymin=0;
  }
  if( ymax>*(axes+1) ){
    printf("Requested line and scan width takes you outside range of detector!!\nSetting this to edge of detector\n");
    over=ymax-*(axes+1);
    numdata-=over;
  }

  /* Allocate memory for the outdata */
  if ( (outdata=(float *)malloc(*(axes)*sizeof(float))) == NULL ||
       (tempval=(float *)malloc(numdata*sizeof(float))) == NULL ||
       (temppos=(float *)malloc(numdata*sizeof(float))) == NULL ){
    
   printf("center: Memory allocation for output data arrays failed\n");
   exit(1);
  }

  for(i=0; i<*(axes); i++){ /* Looping over x */

    for(j=0; j<numdata; j++){ /* Looping in the y direction */
      *(temppos+j)=ymin+j; 
      *(tempval+j)=*(data+i+(ymin-1+j)**(axes));
      /*  printf("%f %f\n", *(tempval+j),*(temppos+j)); */
    }
    
    *(outdata+i)=centroid(tempval, temppos, numdata);
  
  }

  for(i=0; i<*(axes); i++){
    printf("%i %f\n",i+1,*(outdata+i));
  }
  
  free(data);
  free(outdata);
  free(tempval);
  free(temppos);

  return 0;

}
