
# Script to define the Cirpass Package which contains all scripts for 
# reducing data for Cirpass. 

procedure cirpass()

bool cirpmotd = yes

begin

string user
string thedir
user="notset"
thedir="notset"

# Load necessary packages

	artdata
	onedspec
	images.immatch

# Define cirpass variables

set cirpraw = "/data/cass55b/optics/"
show("userid") | scan(user)
set cirpred = "/data/cass55b/"//user//"/"
show("cirpred") | scan(thedir)

package cirpass 

## Define scripts

### Iraf scripts
##Pipeline tasks
	task docirpass  = cirpass$docirpass.cl
#	task docirpass2 = cirpass$docirpass2.cl #runs cosmic2 and produces ima2
	task dotarget   = cirpass$dotarget.cl
#	task doajd      = cirpass$doajd.cl
	task dodisplay  = cirpass$dodisplay.cl
	task doflat     = cirpass$doflat.cl
	task dobackup 	= cirpass$dobackup.cl
	task dogemini	= cirpass$dogemini.cl
	task doaat	= cirpass$doaat.cl

##Component tasks
	task stack_read = cirpass$stack_read.cl
	task stack_average = cirpass$stack_average.cl
	task mefarith   = cirpass$mefarith.cl
        task cirphedit  = cirpass$cirphedit.cl
	task cirphprint = cirpass$cirphprint.cl
	task secstat    = cirpass$secstat.cl
	task secgain    = cirpass$secgain.cl
	task _logic_check = cirpass$_logic_check.cl
	hide _logic_check
	task mktoday   = cirpass$mktoday.cl
	task $mk2ktoday = cirpass$mk2ktoday.cl
#	task gainmeas   = cirpass$gainmeas.cl
#	task get_gain   = cirpass$get_gain.cl
#	task gain       = cirpass$gain.cl
#	task ldisplay   = /home/cirpass/iraf/ldisplay/ldisplay.e
#	task quickdisp  = cirpass$quickdisp.cl
#	task copy_imsets = cirpass$copy_imsets.cl
#	task extract1    = cirpass$extract1.cl
	task doread      = cirpass$doread.cl
	task idisplay    = cirpass$idisplay.cl
#	task sub         = cirpass$sub.cl
#	task findpos     = cirpass$findpos.cl
#	task findpos_auto= cirpass$findpos_auto.cl
	task locatepeaks = cirpass$locatepeaks.cl
	hide locatepeaks
	task locatepeaks_sep = cirpass$locatepeaks_sep.cl
	hide locatepeaks_sep
	task mefdisplay  = cirpass$mefdisplay.cl
#	task gausspeaks = cirpass$gausspeaks.cl		
	task fibcal     = cirpass$fibcal.cl
	task centroidpeaks=cirpass$centroidpeaks.cl
	hide centroidpeaks
	task usm	= cirpass$usm.cl
	task mefmedian  = cirpass$mefmedian.cl
	task ohmask     = cirpass$ohmask.cl
        task ifuoffset  = cirpass$ifuoffset.cl
        task makewvcal  = cirpass$makewvcal.cl
        task wvcal      = cirpass$wvcal.cl
#       task szap       = cirpass$szap.cl
 	task coscirp    = cirpass$coscirp.cl
        task mosaic_ifu = cirpass$mosaic_ifu.cl
#       task beam_switch= cirpass$beam_switch.cl
	task badmask	= cirpass$badmask.cl
	task moscal	= cirpass$moscal.cl
	task mossort	= cirpass$mossort.cl
	task datamonitor= cirpass$datamonitor.cl
	task read_header= cirpass$readheader.cl
	task lensoffset	= cirpass$lensoffset.cl

# C programs 

        task $zsub      = "$$CIRPBIN/zsub $*"
        task $mkerr     = "$$CIRPBIN/mkerr $*"
        task $lincorr   = "$$CIRPBIN/lincorr $*"
        task $cosmic    = "$$CIRPBIN/cosmic $*"
	hide cosmic
#       task $cosmic2   = "$$CIRPBIN/cosmic2 $*"
        task $plot      = "$$CIRPBIN/plot $*"
        task $lsqfit    = "$$CIRPBIN/lsqfit $*"
#       task $bit_check = "$$CIRPBIN/bit_check $*"
        task $addfibreinfo="$$CIRPBIN/addfibreinfo $*"
        hide addfibreinfo
#	task $optextract = "$$CIRPBIN/optextract $*"
        task $optextract_float = "$$CIRPBIN/optextract_float $*"
	task $specmark	= "$$CIRPBIN/specmark $*"
	task $cirparith	= "$$CIRPBIN/cirparith $*"
	hide cirparith
	task $makemef  	= "$$CIRPBIN/makemef $*"
	task $makemef2  = "$$CIRPBIN/makemef2 $*"
        hide makemef2
	task $makemef3  = "$$CIRPBIN/makemef3 $*"
        hide makemef3
	task $oh_mask	= "$$CIRPBIN/ohmask $*"

# External programs

	task $convert	= "$foreign"
	hide convert
	task $montage	= "$foreign"
	hide montage
	task $sort	= "$foreign"
	hide sort
	#task $touch	= "$foreign"
	#hide $touch

##Package parameters
        task cirpasspars = cirpass$cirpasspars.par 

# Sub packages
	set utils          = "cirpass$Utils/"
	task $utils.pkg    = utils$utils.cl

	set instrument	   = "cirpass$Instrument/"
	task $instrument.pkg = instrument$instrument.cl

# Shell scripts

# print the welcome banner

#if(cirpmotd)
	type ("cirpass$cirpass.motd")

if(access(thedir)){
	cd (thedir)
}

clbye()

end

