#!/usr/bin/perl
#
# Perl Script to do a succession of sequence grabs, with a live grab
# wait in the middle - for tacking gain measurements
#
# Andrew J. Dean 23rd Oct, 2000

print "Enter object name\n";
chop($name=<STDIN>);

print "Enter number of loops per exposure\n";
chop($loops=<STDIN>);

print "Enter number of reads per expousure\n";
chop($reads=<STDIN>);

print "Enter individual exposure time\n";
chop($time=<STDIN>); 

print "Enter total number of exposures required\n";
chop($totnum=<STDIN>);

print "Enter time for the livegrab delay\n";
chop($livedelay=<STDIN>);


$seqprog = "seqgrab";
die "Expected executable $seqprog\n"
    unless (-x "$seqprog");

$liveprog = "livegrab";
die "Expected executable $liveprog\n"
    unless (-x "$liveprog");

$seqcmd = "./$seqprog $name $loops $reads $time";
$livecmd = "./$liveprog $livedelay";

for($i=1; $i<=$totnum; $i++){

# Do the live grab

#   print "Running $livecmd\n";
    die "$liveprog failed\n"
	unless (system($livecmd) == 0);

# Do the sequence grab

#   print "Running $seqcmd\n";
    die "$seqprog failed\n"
        unless (system($seqcmd) == 0 );

}

