
% Generates a graph showing OH lines, atmospheric transmission
% and the J and H pass bands.

% Get data

load Isaac_bright_oh.dat;
ohx=Isaac_bright_oh(:,1);
ohy=Isaac_bright_oh(:,2);

load atmosphere.dat;
atmosx=atmosphere(:,1);
atmosy=atmosphere(:,2);

load j_filter_micro.dat;
load h_filter_micro.dat;
jx=j_filter_micro(:,1);
jy=j_filter_micro(:,2);
hx=h_filter_micro(:,1);
hy=h_filter_micro(:,2);

% Draw graphs

graphout=plot(atmosx,atmosy,'b');
hold on;
J=plot(jx,jy,'g');
H=plot(hx,hy,'m');
ohynorm=ohy.*(0.8/max(ohy));
SX=stem(ohx,ohynorm,'r');
set(SX,'Marker','none');
axis([1,1.9,0,1.3]);
title('Characteristics of the atmosphere in the infrared');
xlabel('Wavelength (\mu{m})');
H=[graphout,J,H,SX(2)];
legend(H,'Atmospheric transmission','J band filter','H band filter','OH line intensities (normalised to 0.8)');

hold off;

% Save to output file
saveas(graphout,'atmosphere.eps','epsc2');

