/* mad.c
 * Calculates a sigima clipped median
 * where sigma is evaluated from the Median Absolute Deviation (MAD) 
 * From the mean of the distribution
 *
 * A. J. Dean, 4th March, 2002.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "fitswrap.h"
#include "mathutils.h"

int main(int argc, char* argv[])
{

  float* data=NULL;
  float average=0;
  float* deviations=0;
  float* clippeddata=NULL;
  float  ksigc=0;    /* Sigma clipping threshold */
  float  meddev=0;
  float  medclip=0;
  float  meanclip=0;
  float tmp=0;
  float sig=0; 
  long axes[2];
  int imsize=0;
  int i=0;
  int count=0;

  /* Check for appropriate input */
  if (argc < 3) {
    fprintf(stderr, 
	    "Usage: %s fits_file sigma_clip_threshold\n", 
	    argv[0]);
    exit(1);
  }

  sscanf(argv[2],"%f",&ksigc);

  /* Open the input fitfile */
  data=readfits_float_clever(argv[1], axes);

  imsize=axes[0] * axes[1];

  /* Allocate memory */
  if ( (deviations=(float *)malloc(imsize*sizeof(float))) == NULL || 
       (clippeddata=(float *)malloc(imsize*sizeof(float))) == NULL ){

   printf("mad: Memory allocation failed!");
   exit(1);
  }


  /* Calculate the mean of the data */
  average=mean(data,imsize);

  printf("mad: Mean of data is %f\n",average);

  /* Calculate the absolute deviation from the mean for each data point */
  for(i=0; i<imsize; i++){

    tmp=*(data+i)-average;
    *(deviations+i)=( tmp < 0 ? -1*tmp : tmp );

  }

  /* Calculate the median absolute deviation */
  meddev=median(deviations,imsize);

  sig=1.4*meddev;
  printf("mad: Sigma of data (median absolute deviation) = %f\n",sig);

  /* Do the sigma clipping */
  count=0;
  for(i=0; i<imsize; i++){
    if( *(deviations+i) < (ksigc * sig) ){
      *(clippeddata+count)=*(data+i);
      count++;
      /*printf("%f\n",*(clippeddata+i));*/
    }
  }

  /* Find the mean and median of the clipped data */
  meanclip=mean(clippeddata, count);
  medclip=median(clippeddata, count);
  printf("mad: Rejected %i pixels\n", imsize-count);
  printf("mad: Sigma clipped mean   = %f\n", meanclip);
  printf("mad: Sigma clipped median = %f\n", medclip);

  free(data);
  free(deviations);
  free(clippeddata);

  return 0;

}
