procedure fibmark(name)

##############################################################################
# 20/6/01 RAJ
# task to fit Gaussians in y direction to marked positions on the image 
# to find the centred position and Gaussian fwhm
# use this to find the centres and Gaussian fwhm for individual well
# separated fibre spectra (eg when individual lenses have been
# illuminated, or calibration fibres 

string name {prompt="Name of fibre image"}

struct *in

begin

string p_name
string tempfile, tempfile1, logfile, tempstr
real junk, y, fwhmreal, r1, r2
real fibpos[0:50]=51(0)
real ypos[0:50]
real fwhm[0:50]=51(0)
int num, nummark

p_name=name

tempfile=mktemp("temp")
tempfile1=mktemp("temp")
logfile=mktemp("log")

#display (p_name, 1, bpmask="BPM", bpdisplay="none", bpcolors="red", overlay="", ocolors="green", erase=yes, border_erase=no, select_frame=yes, repeat=no, fill=no, zscale=yes, contrast=0.25, zrange=yes, zmask="", nsample=1000, xcenter=0.5, ycenter=0.5, xsize=1., ysize=1., xmag=1., ymag=1., order=0, z1=0., z2=0., ztrans="linear", lutfile="")

print("Please mark the y positions of the fibres you wish to fit spatial Gaussians to. \nPress any key, ^D to finish");

rimcursor(p_name,wcs="logical",wxformat="",wyformat="",>>tempfile)

#fitprofs just needs the y coordinate so get this out of tempfile and
#put into tempfile1
in=tempfile
i=0
while(fscan(in,junk,y,junk,junk)!=EOF){
  ypos[i]=y
#  print("i ",i,"marked position ",ypos[i])
  i+=1
}
num=i
delete(tempfile)

print("")
print("Fitting Gaussians using fitprofs")

#fit gaussians for each marked position. have to do this for each one 
#separately as sometimes it doesn't work if try to fit them all
#at the same time
for(i=0;i<num;i+=1){
  tempfile1=mktemp("temp")
  logfile=mktemp("log")
  print(ypos[i],>tempfile1)
  r1=ypos[i]-5
  r2=ypos[i]+5
  tempstr=r1//" "//r2
#  print("position ",ypos[i]," region ",tempstr) 
  fitprofs (p_name, lines="512", bands="", dispaxis=2, nsum="10", region=tempstr, positions=tempfile1, background="", profile="gaussian", gfwhm=2., lfwhm=2., fitbackgroun=yes, fitpositions="all", fitgfwhm="all", fitlfwhm="all", nerrsample=0, sigma0=INDEF, invgain=INDEF, components="", verbose=no, logfile=logfile, plotfile="", output="", option="fit", clobber=no, merge=no)
  delete(tempfile1)

#pull out the centre positions which is the first column in logfile
#and put into array fibpos
  in=logfile
  while(fscan(in,tempstr,junk,junk,junk,junk,fwhmreal)!=EOF){
    if(tempstr!="#"){
      fibpos[i]=real(tempstr)
      fwhm[i]=fwhmreal
    }
  }
  delete(logfile)
}

for(i=0;i<num;i+=1){
  print("marked position ",ypos[i]," centred position ",fibpos[i]," fwhm ",fwhm[i])
}

end
