/* peakcentre.c 
**
** Accurately locates peaks from peakfind using centroiding algorithm
** and medians around image data first
**
** A. J. Dean. 13th Nov, 2001
**
*/

#include <stdio.h>
#include <stdlib.h>
#include "fitswrap.h"
#include "mathutils.h"

int main(int argc, char* argv[]){

  long axes[2]={0};
  float* data=NULL;
  int scanwidth=0;
  int medwidth=0;
  double outdata=0;
  float* tempval=NULL;
  float* temppos=NULL;
  int xinitpos=0;
  int yinitpos=0;
  int ymin=0;
  int ymax=0;
  int over=0;
  int numdata=0;

  int j=0;

  if (argc < 6) {
    
    fprintf(stderr, 
	    "Usage: %s image_file xinitpos yinitpos scan(half)width median_width\n", 
           argv[0]);
    exit(1);
  
  } 

  sscanf(argv[2],"%i",&xinitpos);
  sscanf(argv[3],"%i",&yinitpos);
  sscanf(argv[4],"%i",&scanwidth);
  sscanf(argv[5],"%i",&medwidth);

  /* Scan in y direction */
  ymin=yinitpos-scanwidth;
  ymax=yinitpos+scanwidth;
  numdata=(2*scanwidth)+1;

  /* Open image file */
  data=readfits_float_clever(argv[1], axes);

  if( ymin<0 ){
    printf("Requested line and scan width takes you outside range of detector!!\nSetting this to edge of detector\n");
    ymin=0;
  }
  if( ymax>*(axes+1) ){
    printf("Requested line and scan width takes you outside range of detector!!\nSetting this to edge of detector\n");
    over=ymax-*(axes+1);
    numdata-=over;
  }

  /* Allocate memory for the outdata */
  if ( (tempval=(float *)malloc(numdata*sizeof(float))) == NULL ||
       (temppos=(float *)malloc(numdata*sizeof(float))) == NULL ){
    
   printf("center: Memory allocation for output data arrays failed\n");
   exit(1);
  }

  for(j=0; j<numdata; j++){ /* Looping in the y direction */
    *(temppos+j)=(float)(ymin+j); 
    *(tempval+j)=median( (data+xinitpos-1-(medwidth/2)+(ymin-1+j)**(axes)), medwidth );
    /* printf("%f %f\n", *(temppos+j),*(tempval+j)); */
  }
  
  outdata=centroid(tempval, temppos, numdata);
  printf("%f\n",outdata);

  free(data);
  free(tempval);
  free(temppos);

  return 0;

}
