###############################################################################
# task cirphedit
#
# Task to edit data reduction header keywords in input file
# Uses the editor set in the environment variable editor
###############################################################################

procedure cirphedit(filename)

string filename {prompt="File to be edited"}

struct *in

begin

string l_filename,klist,tempfile,kword,kval
struct line
int pos,len

##query parameters
l_filename=filename

##list of datareduction keywords
klist="ZOFFCORR,MASKCORR,NOISCALC,TIMECALC,LINCORR,UNITCORR,CRIDCALC,BKGCORR,DOWVCAL,DOWVALGN,FLATCORR,DOFLCAL,DOEXTR,DBFILE,MASKFILE,NOISFILE,LINFILE,BKGFILE,EXTRFILE,WVFILE,FLATFILE,CALFILE"

##temporary filename
tempfile=mktemp("temp")

##write keyword values into temporary file
hedit(l_filename,fields=klist,value=".",>> tempfile)

##edit temporary file
edit(tempfile)

##write back keywords values
##CHANGE currently writing all of them, should really only write
##the ones that have changed
in=tempfile
while(fscan(in,line)!=EOF){
  pos=stridx(",",line)
  len=strlen(line)
  line=substr(line,pos+1,len)
  pos=stridx("=",line)
  len=strlen(line)
  kword=substr(line,1,pos-2)
  kval=substr(line,pos+2,len)
  hedit(l_filename,kword,kval,add-,delete-,verify-,show-,update+)
}
delete(tempfile)

end
