#############################################################################
#                                                                           #
# task analyse_gain to look at an image section in mean / var data          #
# produced by iraf gain, or the c executable c_gain                         #
#                                                                           #
# A J Dean, 8th Jan, 2001                                                   #
#                                                                           #
#############################################################################

procedure anaylse_gain(datafiles,sec)

string datafiles  {prompt="Filename root for the mean / var data"}
string sec        {prompt="Image section to do the stats on"}
bool   keep       {mode="h", prompt="Keep output data file?[yes/no]"}
string outdata    {mode="h", prompt="Name for output data file"}

begin

	string sdatafiles, section, tempfile
	int num, i
	real data[100,2]
	bool keepdata
	
	sdatafiles = datafiles
	section    = sec
	keepdata   = keep

	if(keepdata){
		
		tempfile=outdata

	} else {

		tempfile = mktemp("t_e_m_p_")

	}

# Count how many input files there are
	
	num=1	
	while(access(sdatafiles//"_mean_"//num//".fits")){
		
		num+=1
		
	}	
	num-=1
	print("Found ", num,"files")

# Calculate the image statistics and write to tempfile

	for(i=1; i<=num; i+=1){
	
		imstat(sdatafiles//"_mean_"//i//"["//section//"].fits", 
                       fields="mean", format-) | scan(data[i,1])
		imstat(sdatafiles//"_var_"//i//"["//section//"].fits", 
		       fields="mean", format-) | scan(data[i,2])

#		print("Mean ",data[i,1]," Var ",data[i,2])
		print(data[i,1],"	",data[i,2], >> tempfile)

	}


# Fit to a straight line and display output

	lsqfit(tempfile)
	
# clean up

	if(!keepdata){
        	delete(tempfile)
	}

end


