/* centroid.c 
**
** Finds the centroid of a data set!
**
** A. J. Dean. 12th Nov, 2001
**
*/

#include "mathutils.h"

extern double centroid(float* value, float* position, int ndata)
{

  int i=0;
  double product=0.0;
  double sum=0.0;
  
  for(i=0; i<ndata; i++){
    
    product += ( *(value+i) * *(position+i) ); 
    sum += *(value+i);
    
  }

  return ( product / sum );

}
