# ifuoffset.cl
#
# Determines the RA and Dec offsets between lenses on the IFU
#
# A. J. Dean 24th July, 2002

procedure ifuoffset(currentlens,newlens)

int currentlens {prompt="Current lens of object on IFU"}
int newlens {prompt="Lens on the IFU to offset to"}
real lens_scale {mode="lh",prompt="Size of one lens (arcseconds across flats)"} 
real pos_angle {mode="lh",prompt="Position angle of telescope (degrees)"}
real theta_off_N {mode="lh",prompt="Angle between IFU axis and N for PA=0 (degrees)"}
int PA_direction {mode="lh",prompt="Position angle direction from North 1=anticlockwise, 2=clockwise"}
string config_file {mode="lh",prompt="File containing IFU configuration"}
bool dodrawcompass {no, mode="lh", prompt="Draw compass arrows onto display window"}

struct *in {mode="h"}

begin

int nlens # new lens number
int clens # current lens number
real scale # IFU lens size across flats
real PA # Position Angle
real theta # Offset angle
int direction # PA direction from north
string config # IFU config file
bool docompass # Draw an arrow onto the display

real nx,ny # x,y coordinates of new lens
real cx,cy # x,y coordinates of current lens

real offx,offy # x,y offset between lenses

real offRA, offDEC # transformed RA and DEC offsets

real pi=3.1415927

real phi_deg # angle between IFU axis and north degrees
real phi_rad # angle between IFU axis and north radians

real IFU_size_x
real IFU_size_y

real xshift
real yshift
real rotangle

int lens,x,y,gotit # variables for reading in from file

bool exist

char dirRA
char dirDEC

IFU_size_x=(1.0/2.0) # Hexagons
IFU_size_y=sqrt(3.0)/2.0

PA=pos_angle
scale=lens_scale

print("")
print ("The current PA is ", PA,"degrees")
print("The current lens scale is ", scale,"arcseconds per lens")
print("")

clens=currentlens
nlens=newlens

theta=theta_off_N
direction=PA_direction
config=config_file
docompass=dodrawcompass

if(docompass){
	# Check if stsdas is there
		if (!defpac ("stsdas")) {
			stsdas(motd=no)
		}	
}

# Find out the lens positions on the IFU grid

exist=access(config)
if(!exist){
	print("ifuoffset: ERROR! Config file not found")
	bye
}

gotit=0
in=config
while(fscan(in,lens,x,y)!=EOF){
	if(lens==clens){
		cx=x
		cy=y
		gotit+=1
	}
	if(lens==nlens){
		nx=x
		ny=y
		gotit+=1
	}
	if(gotit==2){
		break		
	}	
}

if(gotit!=2){
	print("ifuoffset: ERROR! unable to find requested lens")
	bye
}

#print ("lens ",clens," is at ",cx," ",cy)
#print ("lens ",nlens," is at ",nx," ",ny)

offx=nx-cx
offy=ny-cy

#print("offx = ",offx)
#print("offy = ",offy)

if(direction==1){
	phi_deg=theta+PA
} else {
	phi_deg=theta-PA
}

phi_rad=(phi_deg/360.0) * 2.0 * pi

xshift=offx*IFU_size_x*scale
yshift=offy*IFU_size_y*scale

#print("xshift = ",xshift)
#print("yshift = ",yshift)

if(direction==1){
	phi_deg=theta+PA
} else {
	phi_deg=theta-PA
}

offRA = -1*yshift*cos(phi_rad) - xshift*sin(phi_rad)
offDEC = yshift*sin(phi_rad) - xshift*cos(phi_rad)

if(offRA<=0){
	dirRA="W"
	offRA=offRA*-1
} else {
	dirRA="E"
}

if(offDEC<=0){
	dirDEC="S"
	offDEC=offDEC*-1
} else {
	dirDEC="N"
}

#print ("Offset in RA is ",offRA,dirRA," arcseconds")
#print ("Offset in DEC is ",offDEC,dirDEC," arcseconds")

printf ("\nOffset in RA is %.2f %s arcseconds\n",offRA,dirRA)
printf ("Offset in DEC is %.2f %s arcseconds\n\n",offDEC,dirDEC)

if(docompass){

	if(direction==1){
		rotangle=90+theta+PA
	} else {
		rotangle=90+theta-PA
	}		
		
	compass(input="ifuimage[sci,1].fits", output="ifuimage[sci,1].fits",
		xpos=256,ypos=450, angle=rotangle,frame=2, verb-)
	display("ifuimage[sci,1]",frame=2)

}

end



