# hartmann.cl
#
# iraf script to determine the focus position from two 
# hartmann shutter measurements
#
# A. J. Dean 24th July, 2002

procedure hartmann(x1q,y1q,x2q,y2q,faq,x1s,y1s,x2s,y2s,fbs)

real x1q {prompt="x at hartmann position 1 focus position 1"}
real y1q {prompt="y at hartmann position 1 focus position 1"}
real x2q {prompt="x at hartmann position 2 focus position 1"}
real y2q {prompt="y at hartmann position 2 focus position 1"}
real faq {prompt="Focus value at focus position 1"}
real x1s {prompt="x at hartmann position 1 focus position 2"}
real y1s {prompt="y at hartmann position 1 focus position 2"}
real x2s {prompt="x at hartmann position 2 focus position 2"}
real y2s {prompt="y at hartmann position 2 focus position 2"}
real fbs {prompt="Focus value at focus position 2"}

begin

real x11,y11,x12,y12,x21,y21,x22,y22,fq,fs

real xpq, ypq # centre positions of the two hartmann shutter observations
real xps, yps

real dq, ds # distance between the hartmann positions
real switched # Did it switch sides? +ve no, -ve yes
real focus  # New focus number

x11=x1q
y11=y1q
x12=x2q
y12=y2q

fq=faq

x21=x1s
y21=y1s
x22=x2s
y22=y2s

fs=fbs

# Find the midpoints

xpq = ( (x12-x11) / 2.0 ) + x11
ypq = ( (y12-y11) / 2.0 ) + y11

xps = ( (x22-x21) / 2.0 ) + x21
yps = ( (y22-y21) / 2.0 ) + y21

# Find the distances

dq = sqrt( ((x12-x11) * (x12-x11)) + ((y12-y11) * (y12-y11)) )
ds = sqrt( ((x22-x21) * (x22-x21)) + ((y22-y21) * (y22-y21)) )

# Find out if it switched sides

# ycentre1-y1 * ycentre2-y2 will be pos if same side, negative otherwise

switched= (ypq-y11) * (yps-y21)

if(switched>0){

focus= fq - ( (fq-fs)/(dq-ds) ) * dq 

} else {

focus = fq - ( (fq-fs)/(dq+ds) ) * dq

}

print ("New focus position is ",focus)

end



