/* C program to make a readnoise estimate from a 3D cube file
** 
** AJ Dean, 1st May, 2001
**
*/

#include <stdlib.h>
#include <math.h>
#include "fitswrap.h"
#include "nrroutines.h"

int main(int argc, char* argv[])
{

  float* data;
  float x[200]={0};
  float y[200]={0};
  long axes[3]={0};
  int nread=0;
  int nbytes=0;
  int i=0;
  int j=0;
  int k=0;
  float* sqsum=NULL;
  float* rms=NULL;
  float average=0.0;
  float gain=0;
  int box=0;
  int start=0;
  int finish=0;
  int xpix=0;
  int ypix=0;
  int num=0;

  float a, b, siga, sigb, chi2, q;
  float sig[200]={0};
  int mwt=0;

  int status=0;                        /* Error handle for cfitsio */
  fitsfile *fptr;                      /* fits object as defined by cfitsio */


  /* Check for appropriate input */
  if (argc < 7) {
  
      fprintf(stderr, 
          "Usage: %s in.fits box first_loop last_loop xpix ypix\n", 
           argv[0]);
        exit(1);
  
  }

  sscanf(argv[2],"%i",&box);
  sscanf(argv[3],"%i",&start);
  sscanf(argv[4],"%i",&finish);
  sscanf(argv[5],"%i",&xpix);
  sscanf(argv[6],"%i",&ypix);


  /* Allocate memory for ouput data arrays */
  if ( (sqsum=(float *)malloc(box*box*sizeof(float))) == NULL ||
       (rms=(float *)malloc(box*box*sizeof(float))) == NULL ){

    printf("readnoise: Memory allocation failed!\n");
    exit(1);
  
  }
  
  /* Read in the science extensions */
  data=read_cube(argv[1], axes, axes+1, axes+2);
  
  nread=*(axes) * *(axes+1);
  nbytes=nread*(*(axes+2))*sizeof(float);

  /* Put the data into subarrays */
  /* ( fit expects arrays which start at 1 not 0 ) */

  if ( *(axes+2)>199 ){
    printf("Too many reads, increase x and y arrays in rdncube.c\n");
    exit(1);
  }

  if( start<1 ){
    printf("start is < 1 ! Will use 1 instead\n");
    start=1;
  }

  if( finish>*(axes+2) ){
    printf("finish is > number of reads will use max instead\n");
    finish=*(axes+2);
  }

  num=finish-start+1;

  for(k=0; k<box; k++){ /* This represents y */

    for(j=0; j<box; j++){ /* This represents x */
      
      for(i=1; i<=num; i++){
	x[i]=(float)(i);
	y[i]=*(data + (i-1+start-1)*nread + (k+ypix-1)**(axes) + (j+xpix-1) );

      }

      /* Fit them to a straight line and return the intercept and gradient */
      fit(x, y, num, sig, mwt, &a, &b, &siga, &sigb, &chi2, &q);

      /* Subtract actual value from fit and accumulate variance */
      sqsum[j+box*k]=0;

      for(i=1; i<=num; i++){

	sqsum[j+box*k] += ( y[i] - b*i - a ) * ( y[i] - b*i - a )  ;

      }

      rms[j+box*k]=sqrt( ( 1/((float)(num)-1) ) * sqsum[j+box*k] );  

    }
    
  }

  /* Find out the gain */  
  if ( fits_open_file(&fptr, argv[1], READONLY, &status) )  
    printerror ( status ) ;

  /* Get info from header */
  if ( fits_read_key(fptr, TFLOAT, "GAIN", &gain, NULL, &status) )
    printerror ( status ) ;
 
  /* Close the file freeing memory allocated for fitsfile fptr */
  if ( fits_close_file(fptr, &status) )
    printerror ( status );

  average=0.0;
  
  for(k=0; k<box; k++){
    
    for(j=0; j<box; j++){
      
      /*   printf("readnoise: rms noise in pixel %d,%d = %fDN = %fe-\n",
	     j+1,k+1,*(rms+k*box+j),*(rms+k*box+j)*gain);
      */
      average+=*(rms+k*box+j);
      
    }
    
  }
  
  average/=(box*box);

  printf("rdncube: average rms noise in %d by %d box = %fDN = %fe-\n",
	 box,box,average,average*gain);
  

  free(sqsum);
  free(rms);
  free(data);

  return 0;

}



