
/* C Program to read in data from a file and then fit the data to a
** straight line, returning the intercept, gradient and chi squared
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "nrroutines.h"
/* #include "cpgplot.h" */      /* for the graphics output */

int main(int argc, char* argv[])
{

  /* Initialise all the variables */
  float xpos[1000]={0},  ypos[1000]={0};
  float a, b, siga, sigb, chi2, q;
  float sig[1000]={0};
  float fitx[2]={0};
  float fity[2]={0};
  float xminval=0;
  float xmaxval=0;
  float yminval=0;
  float ymaxval=0;
  float fwhm=0;
  char title[100];
  
  int mwt=0;
  int n=1;
  int i=0;
  int j=0;
  int fibnum=508;
  int count=0;
  float outdata[509]={0};
  float start=0;
  float end=0;

  int num;
  char pm=(char)177; /* The plus / minus symbol */
  /* char outputdevice[]="/xwindow"; */      /* output device */

  FILE* datain;

  if ( argc < 3 ){
   
    printf("Usage: %s datafile fwhm\n", argv[0]);
    exit(1);
    
  }
  
  sscanf(argv[2],"%f",&fwhm);

  /* Read in the data */
  if ( !(datain = fopen(argv[1],"r")) ){
    
    printf("Failed to open the input data file\n");
    exit(1);
  }

  n=1;   /* Fit expects arrays starting at 1 -> N */

  while ( fscanf(datain,"%f %f",(xpos+n),(ypos+n)) !=EOF ){
    
    /*    printf(" %f\t%f\n",*(xpos+n),*(ypos+n)); */
    n+=1;
    if( n>=1000 ){
      printf("Too many data points in file.\n Limit is currently 1000.\n") ;
      exit (1);
    }
    
  }
    
  fclose(datain); 
 
  num=n-1;
  
  /* printf("File contains %i data points\n",num); */

  /* Fit them to a straight line and return the intercept and gradient */
  fit(xpos, ypos, num, sig, mwt, &a, &b, &siga, &sigb, &chi2, &q);
 
  /* printf("Gradient = %f\nIntercept = %f\n",b,a); */
 
  /* Make up a straight line graph of the fit */
  xminval=*(xpos+1)*0.85;
  xmaxval=*(xpos+num)*1.15;
  yminval=*(ypos+1)*0.85;
  ymaxval=*(ypos+num)*1.15;
  
  fitx[0]=xminval;
  fity[0]=a+b*fitx[0];
  fitx[1]=xmaxval;
  fity[1]=a+b*fitx[1];

  /* Plot the data in a graph */
  /* Open graphics device. */      
  /*if(cpgbeg(0, outputdevice, 1, 1) != 1)
    return 1; */

  /* Plot the output on screen */
  /* Define coordinate range of graph and draw axes. */
  /*cpgenv(xminval, xmaxval, yminval, ymaxval, 0, 0);*/

  sprintf(title,"Gain = %f %c %f e/DN, Read noise = %f", 1/(b), pm, 
	  (1/(b))*(sigb)/(b), sqrt((1/(b))*(a)));
  
  /* Label the axes */
  /*  cpglab("Xpos", "Ypos", title);*/
  
  /*  Plot the line graph. */
  /*  cpgsci(5); */ /* Blue lines */
  /*  cpgline(2, fitx, fity); */
  
  /*cpgsci(1); */ /* White points */
  /* cpgpt(num,(xpos+1),(ypos+1),5); */

  /* Close the graphics device */
  /*cpgend();*/

  /* Do the interpolation */
  start=xpos[1];
  end=xpos[num];
  count=1; /* This indexes outdata */

  /* Check start of data */
  if(start!=1.000){
    
    for(i=1; i<(int)start; i++){

      outdata[i]= ypos[1] - (start-(float)i)*b;
      count++;

    }

  }

  /* Check end of data */
  if(end<fibnum){

    for(i=end+1; i<=fibnum; i++){
      outdata[i]=ypos[num] + ((float)i-xpos[num])*b; 
    }
  }

  for(i=1; i<=num; i++){
    
    if( ( (int)xpos[i]!=count && i<(int)xpos[num] )){ 
      /* Missed some fibres so interpolate */
      
      start=(int)xpos[i-1];
      end=(int)xpos[i];
      for(j=start+1; j<end; j++){
      
	outdata[count]= ypos[i-1] + ( ((ypos[i] - ypos[i-1]) / ((float)end-(float)start)) * ((float)j-(float)start) ) ;
	count++;

      }
      
    }      
     
    outdata[count]=ypos[i];
    count++;
     
  
  }
  
  for(i=1; i<=fibnum; i++){
    printf("%f %f 2 0 0\n", outdata[i], fwhm);
  }
  
  return 0;
  
}








