# if !defined(FITSWRAP_)
# define FITSWRAP_

# if defined(_cplusplus)
extern "C" {
# endif

/* fitswrap.h -- header file for fitswrap.c */

#include "fitsio.h"  /* For the cfitsio Library */
#include "cirpass.h" /* General cirpass definitions */

#define FLEN_EXT 4     /* Allows up to 999 extensions in a file name */
#define FLEN_EXTNAME 9 /* Maximum lenght of extension name keyword */
                       /* Both include space for trailing /0 */

/* Utility routines */

  extern void printerror(int status);
  extern int readkeys(const char *p_fname,long *axes, int* bitpix);
  extern int read_float_keys(char* p_fname, char* keynames[], float* data, 
			     int numtoread);
  extern int read_int_keys(char* p_fname, char* keynames[], int* data, 
			     int numtoread);
  

/* Routines to read in fits data - allocates memory dynamically */
  extern float *readfits_float(const char *fn, int ext); 
                                                   /* fn is fits filename 
                                                    * ext is extension number,
						    * 0 should be used for 
						    * zero extension files
						    * returned pointer must
						    * be freed 
						    */

  extern float *readfits_float_clever(const char *fn,  long* axes);
  /* Returns image data from a standard fits file, or image data from 
     sci,1 if it's a MEF file. Returns image dimensions in naxes which 
     must be 2D ! */  

  extern float* read_cube(char* filename, long* nx, long* ny, long* nz);

  extern int read_float(const char *fn, float* data); /* Expects memory to 
						       * already be allocated
						       * !! untested !!
						       */
  
  extern float *readfits_float_extver(const char *fn, const char *p_extname,
				      int extver);

                                               /* p_extname is extension name
						* extver is extension version
						*/

  extern double *readfits_double_extver(const char *fn, const char *p_extname,
					int extver, long* nx, long* ny);



/* Routines to write out fits data */
  extern int writefits_float_basic(const char* outfile, long* naxes, float* data);

  /* outfile is the name of the fits file to be written
   * naxes is an array of the same dimension as the image data
   * where each element contains the number of pixels in the dimension
   * data is the actual image data
   */

  extern int writefits_float_header_clever(const char *output_file, 
					   const char *header_file, 
					   long* naxes, int naxis, 
					   float* data);

  /* Matches writefits_float_clever. A plain fits file is written
   * using the header from the header file. If the header file is a MEF
   * file then the header from the SCI,1 extension is used, otherwise
   * just the original header
   */

  extern int writefits_double_basic(const char* outfile, long* naxes, double* data);

  extern int writefits_float_header(const char *output_file, 
				    const char *header_file, long* naxes, 
				    int naxis, float* data);

  /*  extern int writefits_float(const char* outfile, const char* headerfile, int nx, int ny, float* data);*/

  extern int writefits_short_basic(const char* outfile, long* naxes, short* data);

  extern int write_3d_cube(char* filename, float* data, long* axes, int naxis);


/* Multi Extension FITS file routines */
  /* These read / write groups of data of the same extension type 
   * (sci, err, time ...)
   */


  extern int readkeys_MEF(const char *p_fname,long *axes, int* nextend,
			  int* bitpix);

  extern float* read_ME_FITS(char* filename, char* exttype, long* nx, 
			     long* ny, int* nextend);


  extern short* read_ME_FITS_short(char* filename, char* exttype, long* nx, 
				   long* ny, int* nextend);

       /* nx, ny and nextend are returned, 
        * the float* returned is allocated dynamically and needs to be freed
        */

  extern float** read_table(const char *filename, int pos, int numhead,  
			    char* keywords[], float** keydata, int* numcols, 
			    int* numrows);

  extern float** read_table_check(const char *filename, int pos, int numhead,  
				  char* keywords[], float** keydata, 
				  int* numcols, int* numrows);
  
  /* Reads data from the table extensions at position pos, numcols and numrows
   * are returned. numhead, keywords and keydata are all supplied by the 
   * calling function - these are additional keywords to read in from 
   * the table and will not be used if numhead = 0.
   * The float** (data) returned needs to be freed e.g.:
   * for(i=0;i<numcols; i++){
   *   free( *(data+i) );
   * }
   * free(data);
   *
   * the _check version will return a null pointer if no table is found
   */


  extern char** read_table_column_names(const char *filename, int pos, 
					int* numcols, int* numrows);
  

  extern int write_ME_FITS_type(char* filename, char* exttype, float* data, 
				long* nx, long* ny, int nwrite);
  
  extern int write_ME_FITS_type_short(char* filename, char* exttype, 
				      short* data, long* nx, long* ny, 
				      int nwrite);
       
       /* filename is name of ME FITS file
	* exttype is the extension type to be read / written
	* nx and ny are the image dimensions
	* nwrite is the number of extensions to write out.
	*/

  extern int writefits_cirp_ME_FITS(const char *outfile, float* data[], 
				    long* naxes, char* keynames, int numkeys);

  extern int writefits_cirp_ME_FITS_head(const char *outfile, 
					 const char* headerfile, 
					 float* data[], long* naxes);

  /* ****  writefits_cirp_ME_FITS head has not been checked !!!!!!!  ******/

  /* This writes out 4 extensions + a primary header given the data in 
   * data [] which should be ordered as sci, err, dq and time extensions,
   * to the file  outfile. Adding in more keys to the primary header
   * using keynames and numkeys, these should be created with get_key_names.
   * keynames can be set to NULL if you don't want to add in more keyworks.
   * The head version uses the primary header from the headerfile as the 
   * header for the new file and has not been tested !!!
   */


  extern int write_ME_FITS(const char* outfile, const char* exts[],
			   float* data[], int nextend, long* naxes);

  /* Writes a ME FITS file, with no data in primary header, extensions
   * as named in exts corresponding to data in data 
   */


  /* Routine to read in a series of extensions, give starting imset and number
     of extensions to read */
  
  float* read_imset(char* filename, int imset_wanted, int nimset, 
		    char** names,long* nx, long* ny, int* bitpix);

  /* imset_wanted is the extver of the imset you want, nimset is the number
   * of images in an imset, names holds the names of the imsets read in,
   * nx and ny are the image dimensions, bitpix is bits per pixel in image,
   * the pointer returned needs to be freed 
   */


  extern int insert_table(const char* filename, int pos, int numhead, 
			  char* keywords[],  float** keydata, int numcol,  
			  char* colnames[], int numrows, float** data);

  extern int append_table(const char* filename, int pos, int numhead, 
			  char* keywords[],  float** keydata, int numcol,  
			  char* colnames[], int numrows, float** data);

  extern int add_table_column(const char* filename, int position, int nadd,
			      char* colnames[], float** coldata, int numrows);

  extern int overwrite_table_column(const char* filename, int position, 
				    int colposition, int nadd, 
				    char* colnames[], float** coldata, 
				    int numrows);

  extern int write_cirp_copy_hdu(char* template_file, char* output_file, 
				 char* exts[], double* data[], int numdata,
				 int naxis, long* naxes);

  extern int write_cirp_copy_hdu_float(char* template_file, char* output_file, 
				       char* exts[], float* data[], 
				       int numdata, int naxis, long* naxes);

  
  /* The primary header and table from template file is used to create the new
     file output_file. numdata extensions are also added to the output file,
     where ext[n] and data[n] are paired data. naxis is number of axes in the
     data, and long* naxes contains their dimensions */

  extern int write_cirp_mef(char* template_file, char* output_file, 
			  char* exts[], float* data[], int numdata, int naxis,
			    long* naxes, int next);
  
  /* Very similar to write_cirp_copy_hdu_float, except you can have more than 
   * 1 extension version, i.e. more than the 1st four imsets
   */

  
  /* MEF Utility routines */

  extern char* get_key_names(const char* p_fname, int* numfound);

  /* Reads all the header keys from the fitsfile p_fname. 
   * The char* returned is allocated dynamically and must be freed, 
   * it contains each card read, null terminated.
   * The records begin at location 81*i, where 0<=i<numfound.
   * numfound is the number of keys found in the header
   */


  extern int addkeys_int(const char* p_fname, char* keynames[], int* keydata,
			 int numkeys, int headernum);
  extern int addkeys_double(const char* p_fname, char* keynames[], 
			    double* keydata, int numkeys, int headernum);
  extern int addkeys_float(const char* p_fname, char* keynames[], 
			   float* keydata, int numkeys, int headernum);
  extern int addkeys_string(const char* p_fname, char* keynames[], 
			    char* keydata[], int numkeys, int headernum);
  
  /* adds in keys of the datatype to header number headernum. The first 
   * header has headernum=0
   */

  extern int write_key_names(const char* p_fname, char* keynames, 
			       int numkeys);

  extern int datatype(int* bitpix, int* dtype);

  /* converts the bitpix from the header to a read write value for the 
   * cfitsio routines
   */


# if defined(_cplusplus)
}
# endif

# endif /* defined(FITSWRAP_) */











