#include <stdio.h> /* Standard Input/ Output Library */
#include <stdlib.h>
#include <string.h>
#include "matrix_solver_float.h"
#include "extract_float.h"
#include "fitswrap.h"
#include "libaddapinfo.h"

/* 15/12/01 changed to use the fwhm in the extraction parameters file
   instead of the hardwired value.
   removed call to gettype subroutine
   changed getphi to find integration limits separately for each peakpos
*/

#define MAX(a,b) ((a)>(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))
#define FIBARR_SIZE 508
/*NBIN 10000 for reasonable speed in getphi but 100000 more accurate*/
/*#define NBIN 100000*/
#define NBIN 10000

int main (int argc, char* argv[])
{
  /*extern int IMSIZE;   these are declared in datapars.h.*/
  /*extern int 502; would like to declare array sizes in terms of*/
  float dd[1];         /*1024 and 502 but doesn't work*/
  int indx[FIBARR_SIZE];       /*so make them bigger than 1024 and 508 will be*/
  float peakpos[FIBARR_SIZE];
  float fwhm[FIBARR_SIZE];
  float fibpars[FIBARR_SIZE*7]={0};
  float pixval[1024];
  float pixvar[1024];
  float gaussval[NBIN];
  float *outdata[2];
  float *data[1024];
  float *var[1024];
  float *phi[FIBARR_SIZE];
  float *A[FIBARR_SIZE];
  float *AA[FIBARR_SIZE];
  float *al[FIBARR_SIZE];
  float *peakarr[1024];
  float *fwhmarr[1024];
  float b[FIBARR_SIZE];
  float c[FIBARR_SIZE];
  float d[FIBARR_SIZE];
  float r[FIBARR_SIZE];
  float u[FIBARR_SIZE];
  float outvar[FIBARR_SIZE];
  float cf, lastpixondet, firstpixondet, step;
  char *keydata[FIBARR_SIZE];
  char filename[255], infile[255], outfile[255];
  char *exts[]={"SCI","VAR"};
  char *keynames[FIBARR_SIZE];
  char exttype[4];
  int numpk, numpklast, numpkfirst;
  int i, j, k, l, polyorder, nval, keynum, ival;
  int naxis=2;
  int num=9; /*num=9  (apnumxxx + /0)*/
  int num1=10;
  long naxes[2]={1024,FIBARR_SIZE}; 
  int ERROR1=0; /*variable to check if variance=0 during optimal extraction*/

  for(i=0;i<FIBARR_SIZE;i++){
    phi[i]=(float*)malloc(1024*sizeof(float));
    A[i]=(float*)malloc(5*sizeof(float));
    AA[i]=(float*)malloc(5*sizeof(float));
    al[i]=(float*)malloc(2*sizeof(float));
    if ( (keynames[i]=(char*)malloc(num*sizeof(char))) == NULL ){
      printf("stack: Memory allocation for char pointers failed!");
      exit(1);
    }
    if ( (keydata[i]=(char*)malloc(num1*sizeof(char))) == NULL ){
      printf("stack: Memory allocation for char pointers failed!");
      exit(1);
    }    
  }
  for(i=0;i<1024;i++){
    data[i]=(float*)malloc(1024*sizeof(float));
    var[i]=(float*)malloc(1024*sizeof(float));
    peakarr[i]=(float*)malloc(FIBARR_SIZE*sizeof(float));
    fwhmarr[i]=(float*)malloc(FIBARR_SIZE*sizeof(float));
  }
  for(i=0;i<2;i++){
    outdata[i]=(float*)malloc(1024*FIBARR_SIZE*sizeof(float));
  }
  /*  for(i=0;i<NBIN;i++){
    gaussval=(float*)malloc(NBIN*sizeof(float));
    }*/
  /*printf("Running optextract_float\n");*/

 /* Check what input we received */
  if (argc == 5 ) {
  
    strcpy(infile,argv[1]);
    strcpy(outfile,argv[2]);
    strcpy(exttype,argv[3]);
    strcpy(filename,argv[4]);

  } else {

    printf("You may specify the following inputs on the command line if you wish\n");
    printf("%s image_file out_file sum||opt fibre_info\n\n",argv[0]);
 
    /*read FITS file containing spectra to be extracted */
    printf("input FITS filename containing spectra to be extracted\n");
    scanf("%s",infile);

     /*read output filename input by user*/
    printf("input output FITS filename\n");
    scanf("%s",outfile);

    /*summed or optimal extraction ?*/
    printf("do you require simpled summed extraction (sum) or optimal extraction (opt)?\n");
    scanf("%s",exttype);
    printf("exttype %s\n",exttype);
 
    printf("which file contains the fibre info?\n");
    scanf("%s",filename);

  }

  /*read coordinates of peaks, value of fwhm and curvature pars from file */
  /*CHANGE to be from table header*/
  /*printf("calling getval2\n");*/
  numpk = getval2(filename, fibpars);

  /*printf("%s %d\n","numpk",numpk);*/
  /*use order of polynomial from fibpars to work out how many values per 
    fibre, and hence total number of fibres*/
  polyorder=*(fibpars+2);
  /*printf("polyorder %d\n",polyorder);*/

  /*number of values per fibre = nval*/
  nval=4+polyorder;
  numpk=numpk/nval;


  /*work out big array containing peakpos for each column.
    the way i need to access this information is, for each xpixel=wavelength
    value on the detector, to get the y positions of all the spectra at this
    wavelength value.
    so to make this info easy to access i put it along the rows of the array
    i.e. one row of the array per xpixel on the detector, and the row
    contains the positions of all the spectra at that xpixel.
    
    numpklast contains the array index of the last fibre where the whole 
    spectrum falls on the detector

    numpkfirst contains the array index of the first fibre where the whole
    spectrum falls on the detector

    whole spectrum on detector means at least one pixel either side of peak
    pixel
    
    fill the array along columns, ie for each spectrum get the coefficients
    describing the curvature from fibpars, and then work out the position of 
    this spectrum for each xpixel=wavelength value on the detector..  

    in a similar fashion, also find the large array describing fwhm for
    each column. currently this constant along a spectrum*/

  numpkfirst=0;      /*array indices of first and*/
  numpklast=numpk-1; /*last spectra on detector*/

  lastpixondet=1023.5;
  firstpixondet=1.5;

  for(j=0;j<numpk;j++){
    for(i=0;i<1024;i++){
      /*printf("spectrum %d xpixel %d\n",j,i);*/
      peakarr[i][j]=0;
      ival=1;

      /*work out the value of the polynomial describing the jth spectrum 
	at the ith wavelength value*/
      for(k=0;k<=polyorder;k++){  
	cf=*(fibpars+3+k+j*nval); 
	peakarr[i][j]=peakarr[i][j]+cf*(float)ival;
	/*need i+1 here because array index i contains value for pixel
	  i+1 ie pixels numbered from 1, arrays from 0*/
	ival=(i+1)*ival;
      }

      /*if(j==200)printf("final value for spectrum %d peak at xpixel %d = %g\n",j,i,peakarr[i][j]);*/
      if(peakarr[i][j]>=lastpixondet)
	numpklast=MIN(numpklast,j-1);
      if(peakarr[i][j]<firstpixondet)
	numpkfirst=MAX(numpkfirst,j+1);
      /*if(i==0)
	printf("peakarr %g j %d numpkfirst %d numpklast %d\n",peakarr[i][j],j,numpkfirst,numpklast);*/

      /*fwhm array
	at the moment the fwhm is constant for a given spectrum (j) for all
	wavelength values (i). 
	if necessary could change this so that the extraction parameters
	file contains coefficients describing how the fwhm changes with
	wavelength*/
      fwhmarr[i][j]=*(fibpars+1+j*nval);

    }
  } 
  /*5/11/01*/
  numpk=numpklast-numpkfirst+1;
  printf("first fibre on detector %d, last fibre on detector %d, numpk, %d\n",numpkfirst+1,numpklast+1,numpk);


  /*read SCI,1 values from FITS file into array data.
  data is a 2D array which contains the data
  in data the wavelength pixel changes along the columns and the spatial
  pixel changes along the rows, ie data[i][j] is pixel j,i 

  read VAR,1 values from FITS file into array var.
  same structure as data array*/

  /*printf("reading %s \n",infile);*/
  readdata(infile, data,"SCI",1);
  readdata(infile,var,"VAR",1);
  /*printf("after readdata\n");*/

  /*  printf("peakpos for column 0\n");
  for(i=0;i<1024;i++){
        printf("i %d\n",i);
    for(j=0;j<numpk;j++){
      peakpos[j]=peakarr[i][j];
            if(i==0)
	printf("j %d peakpos %g\n",j,peakpos[j]);
	}
	}*/
  

  if(strcmp(exttype,"sum")==0){
    printf("optextract: Summed extraction\n");
    for(i=0;i<1024;i++){
      /*get array of peakpos for this column*/
      for(k=numpkfirst;k<=numpklast;k++){
	j=k-numpkfirst;
	/*5/11/01 changed peakarr[i][j] to peakarr[i][k]*/
	peakpos[j]=peakarr[i][k];
	/*printf("i %d j %d peakpos %g\n",i,j,peakpos[j]);*/

	/*	output data is just sum in 3 pixels closest to peakpos.
		assume pixel edges are 0.5 (as in IRAF), then
		value peakpos is in pixel int(peakpos+0.5).
		want to sum this pixel and the pixels either side.
		note that array position is one less than pixel position, 
		hence peakpos-2, peakpos-1 and peakpos*/
	outdata[0][j*1024+i]=data[(int)(peakpos[j]+0.5)-2][i] + data[(int)(peakpos[j]+0.5)-1][i] + data[(int)(peakpos[j]+0.5)][i];

	/*output error is just sum of errors in 3 pixels closest to peakpos*/
	outdata[1][j*1024+i]=var[(int)(peakpos[j]+0.5)-2][i] + var[(int)(peakpos[j]+0.5)-1][i] + var[(int)(peakpos[j]+0.5)][i];
	/*if(i==1){
	  printf("j %d adding %d, %d, %d with vals %g, %g, %g outdata %g\n",j,(int)(peakpos[j]+0.5)-1,(int)(peakpos[j]+0.5),(int)(peakpos[j]+0.5)+1,data[(int)(peakpos[j]+0.5)-2][i],data[(int)(peakpos[j]+0.5)-1][i],data[(int)(peakpos[j]+0.5)][i],outdata[0][j*1024+i]);
	  }*/
      }
    }
  }

  else if(strcmp(exttype,"opt")==0){
    printf("optextract: Optimal extraction\n");

    /*step size for Gaussian integration*/
    step=10.0/NBIN;

    /*initialize and populate Gaussian array values*/

    for(k=0;k<NBIN;k++){
      gaussval[k]=0;
    }
      
    getgauss(gaussval,step,NBIN);
 
    for(i=0;i<1024;i++){

      /*printf("column %d\n",i);*/

      /*initialize arrays*/
      for(k=numpkfirst;k<=numpklast;k++){
	j=k-numpkfirst;
	r[j]=0;
	u[j]=0;
	b[j]=0;
	c[j]=0;
	d[j]=0;

	peakpos[j]=peakarr[i][k];
	fwhm[j]=fwhmarr[i][k];

	for(l=0;l<1024;l++){
	  phi[j][l]=0;
	}
	for(l=0;l<5;l++){
	  A[j][l]=0;
	}
      }

      /*printf("before getphi\n");
	printf("numpk %d numval %d type %d\n",numpk,numval,type);*/
      getphi(peakpos, fwhm, numpk, 1024, phi, gaussval, step);

      /*feed data a column at a time into routines to find value of each spectrum
	pixval is the vector that contains a column at a time*/
      for(j=0;j<1024;j++){
	pixval[j]=data[j][i];
	pixvar[j]=var[j][i];

	/*if the error value is 0, then set it to 1, because optimal extraction divides
	  by this value*/
	if(pixvar[j]==0){
	  pixvar[j]=1;
	  ERROR1=1;
	}
	/*check*/
	/*	if(i==0){
	  if((j>300)&&(j<306)){
	    printf("column %d row %d pixval %g pixvar %g\n",i+1,j+1,pixval[j],pixvar[j]);
	  }
	  }*/
      }    

      getdiag(phi,pixvar,b,c,d,A,numpk,1024);

      /*   printf("extracting spectra\n");*/
      
      /*printf("solving for column %d\n",i);*/
  
      getr(pixval,pixvar,phi,numpk,1024,r);

      /*get output variance */
      getoutvar(pixvar,phi,numpk,1024,outvar);
      
      /*      if(type==1){*/
      /*tridiag(b,c,d,r,u,numpk);*/
	/*}*/
      /*else{*/
      /*try using 5 diag matrix all the time*/
      bandec(A,numpk,2,2,al,indx,dd);
      banbks(A,numpk,2,2,al,indx,r);
	/* }*/
    
      /*printf("writing output matrix for column %d\n",i);*/
      for(k=numpkfirst;k<=numpklast;k++){
	j=k-numpkfirst;
	/*if(type==1){
	  outdata[0][j*1024+i]=u[j];
	}
	else{*/
      outdata[0][j*1024+i]=r[j];
      /*check*/
/*      if(i==0){
	if((j>146)&&(j<150)){
	  printf("spectrum %d peakpos %g fwhm %g x pixel %d output value r %g\n",j+1,peakpos[j],fwhm[j],i+1,r[j]);
	}
	}*/
      outdata[1][j*1024+i]=outvar[j];      
      }
    }
    if(ERROR1==1)
      printf("Some of the values in the input image variance array were = 0.\n These values were set = 1 during execution.\n");
  }

  /*write out data to FITS file*/
  printf("optextract: writing output FITS file %s \n",outfile);
  naxes[1]=(long)numpk;
  write_cirp_copy_hdu_float(infile,outfile,exts,outdata,2,naxis,naxes);

  /*printf("adding APNUM keywords\n");*/
  /*add apnum header keywords to output file because splot needs them*/
  /*syntax for keywords APNUM# * peakpos*/
  /*APNUM# - # starts at 1 and increments by 1*/
  /*is the number of the fibre in the slit*/
  /*assuming initially that filename (= e.g.fibpars_all.list) contains*/
  /*all the fibres and that all the fibres which fall on the detector 
    are extracted*/

  for(i=numpkfirst;i<=numpklast;i++){
    /*printf("writing apnum header entry for i=%d, fibre=%d\n",i,i+1);*/
    sprintf(keynames[i],"APNUM%d",i-numpkfirst+1);
    sprintf(keydata[i],"%d %g",i+1,*(fibpars+i*nval));
    /*    printf("keyname %s i %d keydata %g\n",keynames[i],i,keydata[i]);*/
    
  }

  keynum=numpklast-numpkfirst+1;

  addkeys_string(outfile,keynames,keydata,keynum,2);

  /*printf("updating table extension with extracted spectrum aperture for each fibre lens\n");*/
  /*run addapinfo subroutine to put in the extracted spectrum aperture for 
    each fibre lens. needs first and last fibre which falls on the detector. 
    assumes all the spectra inbetween this first and last fibre are extracted*/
  libaddapinfo(outfile,numpkfirst+1,numpklast+1);

  for(i=0;i<numpk;i++){
    /*printf("i %d\n",i);*/
    free(phi[i]);
    free(A[i]);
    free(al[i]);
  }

  for(i=0;i<1024;i++){
    free(data[i]);
  }

  return 0;
}


