/* c_get_gain.c
**
** C Program expects a list of FITS images containing mean and sigma data
** The program fits a straight line to the mean / sig data to determine
** the gain and readnoise at each pixel
**
** A. J. Dean 11th Oct, 2000
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "fitswrap.h"
#include "nrroutines.h"
#include "cpgplot.h"      /* for the graphics output */

int main(int argc, char* argv[])
{

  int num=0;
  int i=0;
  int j=0;
  /*  int k=0; */
  int count=0;
  int int_size=0;
  int temp_num=0;
  long axes[2]={0};
  int bitpix=0;

  char* mfilename;
  char* sfilename;
  char* outputdevice=NULL;
  
  const char* exts[]={"GAIN","READNOISE","CHI2"};
  float* data[3]={NULL}; /* !!! Make the size of this array  !!!
			  * !!! the same as exts             !!! */

  typedef float* float_pointer;  
  float_pointer* p_p_meandata;
  float_pointer* p_p_sigdata;

  float* means=NULL;
  float* vars=NULL;
  float* sig=NULL;

  float* gain=NULL;
  float* readnoise=NULL;
  float* chi2image=NULL;
 
  float a, b, siga, sigb, chi2, q;
  int mwt=0;

  float fitx[2]={0};
  float fity[2]={0};
  float xminval=0;
  float xmaxval=0;
  float yminval=0;
  float ymaxval=0;
  char title[100];
  char pm=(char)177; /* The plus / minus symbol */
  
  int xpos=0;
  int ypos=0;

  /* Check for appropriate input */
  if ( argc < 7 ){
    
    printf("Usage: %s meanfiles sigfiles numfiles outfile xcord ycord [file.ps] \n", 
	   argv[0]);
    exit(1);

  }

  if ( 8 == argc ){
 
    if ( (outputdevice=(char *)malloc((strlen(argv[7])+4)*sizeof(char))) 
	 == NULL ){
      
      printf("plot: memory allocation for output file failed\n");
      exit(1);
      
    }
    
    strcpy(outputdevice,argv[7]);
    strcat(outputdevice,"/PS");
    
  } else if ( 7 == argc ){
    
    if ( (outputdevice=(char *)malloc(9*sizeof(char))) == NULL ){
      
      printf("plot: memory allocation for output file failed\n");
      exit(1);
      
    }
    
    strcpy(outputdevice, "/xwindow");
   
  }

  sscanf(argv[3],"%i",&num);
  sscanf(argv[5],"%i",&xpos);
  sscanf(argv[6],"%i",&ypos);

  /*  if ( (xpos > 255) ||  (ypos > 255) ){
    printf("x or y is > 255 which is outside their range\n");
    exit(1);
  }
  */
  /* Allocate memory for the data */
  if ( (p_p_meandata=(float_pointer *)malloc(num*sizeof(float_pointer))) 
       == NULL ||
       (p_p_sigdata=(float_pointer *)malloc(num*sizeof(float_pointer))) 
       == NULL ){
    
    printf("c_get_gain: Memory allocation for data pointers failed!");
    exit(1);
  }
  
  /* Read in the data and renumber to count up*/
  count=num-1;

  /* Find out how many digits in the int */
  int_size=1;
  temp_num=num;
  while( (temp_num/=10) > 1)
    int_size++;
  
  /* The 11 is for _lev_.fits + newline */
  if ( (mfilename=(char *)malloc(strlen(argv[1])+11+int_size) ) == NULL || 
       (sfilename=(char *)malloc(strlen(argv[2])+11+int_size) ) == NULL ){

    printf("c_get_gain: Memory allocation for filename arrays failed");
    exit(1);
  }

  for(i=0; i<num; i++){
 
    strcpy(mfilename,argv[1]);
    strcat(mfilename,"_lev_");
    sprintf(mfilename,"%s%i",mfilename,i+1);
    strcat(mfilename,".fits");

    strcpy(sfilename,argv[2]);
    strcat(sfilename,"_lev_");
    sprintf(sfilename,"%s%i",sfilename,i+1);
    strcat(sfilename,".fits");
    
    /* printf("Reading %s and %s\n",mfilename,sfilename); */

    *(p_p_meandata+count) = readfits_float(mfilename,0); 
    *(p_p_sigdata+count) = readfits_float(sfilename,0); 
    
    /* printf("Random pixel from each image is %f and %f\n",*( *(p_p_meandata+count) + 42738 ),*( *(p_p_sigdata+count) + 23425) ); */

    count--;
  }

  /* Find out the image sizes */
  readkeys(mfilename,axes,&bitpix);
 
  /* Turn the sigma data into vars */
  
  for(i=0; i<num; i++)
    
    for(j=0; j< axes[0]*axes[1]; j++)
      
      *( *(p_p_sigdata+i) + j) *= *( *(p_p_sigdata+i) + j);
 
  for(i=0; i<num; i++)
    printf("var is %f\n",*( *(p_p_sigdata+i) + 723*1024+645));
 
  /* Make up fitting arrays */
  /* Fit expects arrays starting at 1 so need 1 extra bit of space */
  if ( (means=(float *)malloc(sizeof(float)*num+1 )) == NULL || 
       (vars =(float *)malloc(sizeof(float)*num+1 )) == NULL ||
       (sig  =(float *)malloc(sizeof(float)*num+1 )) == NULL ){
    printf("c_get_gain: Memory allocation for fitting arrays failed");
    exit(1);
  }
	
  /* Allocate space for the output gain + readnoise + chi2*/
  if ( (gain=(float *)malloc(sizeof(float)*axes[0]*axes[1])) == NULL || 
       (readnoise=(float *)malloc(sizeof(float)*axes[0]*axes[1])) == NULL ||
       (chi2image=(float *)malloc(sizeof(float)*axes[0]*axes[1])) == NULL ){
    printf("c_get_gain: Memory allocation for output arrays failed");
    exit(1);
  }
  
  /* Open graphics device. */      
  /*    if(cpgbeg(0, outputdevice, -3, 3) != 1)
	return 1; 
  */

  if(cpgbeg(0, outputdevice, 1, 1) != 1)
    return 1; 

  printf("c_get_gain: Fitting the slope to find the gain and readnoise ");
  printf("for each pixel\n");

  for(i=0; i<axes[0]*axes[1]; i++){
  
    for(j=0; j<num; j++){

      *(means+j+1)=*( *(p_p_meandata+j) + i);
      *(vars+j+1) =*( *(p_p_sigdata+j)  + i);

    }

    /* Do the straight line fitting for each pixel and put into output file 
     * arrays (this is the Numerical Recipes in C fitting code)
     */

    fit(means, vars, num, sig, mwt, &a, &b, &siga, &sigb, &chi2, &q);
    *(gain+i)=1/(b);
    *(readnoise+i)=sqrt((1/(b))*(a));
    *(chi2image+i)=chi2;

    /* if( i == (xpos+1024*ypos) || 
	i == ((xpos+1024*ypos)+256) || 
	i == ((xpos+1024*ypos)+512) ||
	i == ((xpos+1024*ypos)+1024*256) || 
	i == ((xpos+1024*ypos)+1024*256+256) || 
	i == ((xpos+1024*ypos)+1024*256+512) ||
	i == ((xpos+1024*ypos)+1024*512) || 
	i == ((xpos+1024*ypos)+1024*512+256) || 
	i == ((xpos+1024*ypos)+1024*512+512) ){
    */

    if( i == ((xpos-1)+1024*(ypos-1)) ){

      /* print the output on screen */

      /*      for(k=1; k<=num; k++){
	printf("mean = %f var = %f chi2 = %f\n",*(means+k),*(vars+k),chi2);
      }
      */

      /* Make up a straight line graph of the fit */
      xminval=*(means+1)*0.85;
      xmaxval=*(means+num)*1.15;
      yminval=*(vars+1)*0.85;
      ymaxval=*(vars+num)*1.15;
      
      fitx[0]=xminval;
      fity[0]=a+b*fitx[0];
      fitx[1]=xmaxval;
      fity[1]=a+b*fitx[1];      

      /* Plot the output on screen */
      /* Define coordinate range of graph and draw axes. */
      cpgenv(xminval, xmaxval, yminval, ymaxval, 0, 0);
      
      sprintf(title,"Gain = %f %c %f e/DN, Read noise = %f", 1/(b), pm, 
	      (1/(b))*(sigb)/(b), sqrt((1/(b))*(a)));
      
      /* Label the axes */
      cpglab("Mean", "Variance", title);
      
      /*  Plot the line graph. */
      cpgsci(5); /* Blue lines */
      cpgline(2, fitx, fity);
      
      cpgsci(1); /* White points */
      cpgpt(num,(means+1),(vars+1),5);
    
    }
  }

  /* Close the graphics device */
  cpgend();

  /* Write out the data */
  data[0]=gain;
  data[1]=readnoise;
  data[2]=chi2image;

  write_ME_FITS(argv[4], exts, data, 3, axes);

  /* Clean up */
  free(outputdevice);
  free(means);
  free(vars);
  free(sig);
  
  free(gain);
  free(readnoise);
  free(chi2image);

  free(mfilename);
  free(sfilename);
  for(i=0; i<num; i++){
    free( *(p_p_meandata + i) );
    free( *(p_p_sigdata + i) );
  }
  
  free(p_p_meandata);
  free(p_p_sigdata);

  return 0;

}




