###############################################################################
# task zerosub                                                                #
# Procedure to subtract zeroth science extension from other science           #
# extensions in multi-extension FITS file.                                    #
# The self subtracted zeroth read extension remains part of the               #
# resultant multi-extension FITS file.                                        #
# The samptime keyword in each extension header is updated by this task.      #
# samptime gives the effective integration time for each science extension.   #
# Because the zeroth read is not taken after exactly zero seconds             #
# samptime = time_obs(extension) - time_obs(zeroth read)                      #
# Created by RAJ 6 June 2000                                                  #
#
# Improvements required:
# Should update the information in the error and data quality extensions
# for each imset. If the time extensions have been populated ie
# timedone=PERFORMED, then should update these as well.
#
#NOTE I think it will be easier to write something like msarith for NICMOS
#and STIS that does arithmetic on imsets. ie updates sci,dq etc
###############################################################################


###!!!!!! I need fixing !!!!! ####################

# Because the zeroth read is not in the last extension, and the program
# overwrites extensions 1 upwards with itself - read zero, once the zeroth
# read has been subtracted from itself it contains zeros and then zeros
# are subtracted from all subsequent extensions !!!
#

###!!!!!!!!!!!!!!!!!!!!!!!!!!!#####################

procedure zerosub(infile)

string infile {prompt="Multi-extension FITS file"}

begin

string finfile, tempstr, zstr, finstr
int nexn,nread,nimset,zexn,totexn
real exttime,ztime,newtime


finfile=infile
#nexn is the no of extensions per imset
nexn=4

#read the total number of extensions from the primary header keyword NEXTEND
tempstr=finfile//"[0]"
hselect(tempstr,"NEXTEND",yes) | scan(totexn)

#read the number of reads per loop from the primary header keyword NREADS
hselect(tempstr,"NREADS",yes) | scan(nread)

##the zeroth read is in loop1,read nread -> in CURR_NDR=nread
##this read may not necessarily be in the input MEF file
##go through each extension in the MEF file and find the one that
##contains loop 1, read nread
##If it doesn't exist the exit with an error message
##when zerosub is called from doschmidt _logic_check will already
##have checked if the zeroth read exists and zerosub won't be
##called if it doesn't

##go through each science extension and find the one with LOOP=zloop, READ=nread
zext=-100
for(i=1;i<=totexn;i+=nexn){
  tempstr=finfile//"["//i//"]"
  hselect(tempstr,"CURR_NDR",yes) | scan(curr_read)
  if(curr_read==nread)
    zext=i
}

if(zext=-100)
  error(10,"zeroth read is in loop 1, read ",nread,". This read is not in the MEF file ",finfile)

print("Zeroth read is in extension ",zext)
zstr=finfile//"["//zext//"]"

#and read time_obs of the zeroth read
hselect(zstr,"time_obs",yes) | scan(ztime)
print("zeroth read read out after ",ztime)

for(i=1;i<=nexn;i=i+nexn){
	tempstr=finfile//"[sci,"//i//"]"
	finstr=finfile//"[sci,"//i//",overwrite]"
#subtract the zeroth read
	imarith(tempstr,"-",zstr,finstr)
#update the samptime keyword for each science extension
	hselect(tempstr,"time_obs","yes") | scan(exttime)
	newtime=exttime-ztime
	hedit(tempstr,"samptime",newtime,add=no,delete=no,verify=no,show=no,update=yes)
}

end
