# moscal.cl
#
# Uses a flat field image from CIRPASS MOS data
# to determine the fibre locations for optextract.
#
# in_config_file should eventually be read from the header.
#
# A. J. Dean 3rd Dec, 2002

procedure moscal(name,config_file,outfile,noise,sigma,width,review)

string name {prompt="Name of MOS flat field image"}
string config_file {prompt="File containing the MOS configuration for the observation"}
string reffile {"/home/cirpass/MOSdat/aat_pos", prompt="Name of file containing reference fibre positions"}
string outfile {prompt="Name of file to contain the new position information"}
bool overw     {mode="l", prompt="overwrite output file?"}
int noise   {prompt="background noise in image"}
int sigma   {prompt="sigma above background which indicates a line"}
int width   {prompt="max area around fibre to search for peak (centroid width)"}
bool review {prompt="View the fit?"}
real fibfwhm {3, prompt="Full width half maximum of a fibre trace (written to fibpos.list)"}

struct *in {mode="h"}

begin

string p_name, p_reffile, p_config_file, p_outfile
string tempfile, tempfile2, tempfile3, tempfile4, tempfile5, junk
string tempfile6, tempfile7, losttraces
bool over,exist, p_review
int p_noise, p_sigma, p_width, line
real p_fibfwhm
real yref[1000]
real ymeas[1000]
int ymeas_pos_id[1000]
real coeffarray[1000,3]
real y
real realpos
int i,j, k, count, matched
int a, b, unwanted
int test_pos, foundit
int answer, temp
int fibres[1000]  # Fibre labels in the current observation
int slit_pos[1000] # Position of labelled fibre in slit
int fibre_label[1000] # Label of fibre in slit, at position slit_pos
int slit_obs[1000] 	# Fibre slit positions in the current observation
int numtot, numfound, numexpected, numtotal, len
int imsizex
real m,c
real mslit, cslit, offset
real mfit, cfit, errcfit, errmfit
real a0, a1, a2, s0, s1, s2
real cterms_a0, cterms_a1, cterms_s0, cterms_s1
real xterms_a0, xterms_a1, xterms_s0, xterms_s1
real x2terms_a0, x2terms_a1, x2terms_s0, x2terms_s1
int beverbose=0

p_name=name

p_config_file=config_file

# check if config_file file exists
exist=access(p_config_file)
if(!exist){
		print("MOS config file does not exist!")
		bye		
		
}

p_reffile=reffile

# check if positions file exists
exist=access(p_reffile)
if(!exist){
		print("Reference position file ",p_reffile," does not exist!")
		bye		
		
}


p_outfile=outfile

# check if file already exists
exist=access(p_outfile)
if(exist){
		print("!!!!! output file exists !!!!!")
		over=overw
		if(over){ 
	  		delete(p_outfile)
		} else {
			print("You should probably pick a different name!")
			bye		
		}
}

p_noise=noise  
p_sigma=sigma  
p_width=width
p_review=review
p_fibfwhm=fibfwhm

##load required packages
utils
tables.motd=no
tables

# check for .fits on the end of input image file

        len=strlen(p_name)
        if(substr(p_name,len-4,len)!=".fits") {
                p_name=p_name//".fits"
        }

display(p_name//"[sci,1]",1)

#Use the middleish line in peakfind

line=500

tempfile=mktemp("_temp_")

print("***** Fibre FWHM hard coded at ", p_fibfwhm,"-> fix this !! *****")

peakfind(p_name,line,p_noise,p_sigma,tempfile)

# Read in data from files into memory

in=p_reffile
i=1
while(fscan(in,y)!=EOF){
	yref[i]=y
	#print("i ",i,"reference found at position ",yref[i])
  i+=1
  if(i>=1000){
	     error(11,"Array for positions found run out of room!")
  }

}

numtot=i-1
print("Found ", numtot, "fibre positions in the reference file")

print("Accurately finding the fibre peak centres in the image")
in=tempfile
i=1
while(fscan(in,y)!=EOF){
	ymeas[i]=0
	peakcentre(p_name, line, y, p_width,1) | scan(ymeas[i])
	#ymeas[i]=y
	#print("i ",i,"found at position ",ymeas[i])
  i+=1
  if(i>=1000){
	     error(11,"Array for positions found run out of room!")
  }

}

numfound=i-1
print("Found ", numfound, "fibres in the image")
print("First fibre at position: ",ymeas[1]," Last fibre at position ",
      ymeas[numfound])

tempfile2=mktemp("_temp2_")
sort("-n", p_config_file,>tempfile2)

in=tempfile2
i=1
while(fscan(in,a)!=EOF){
	fibres[i]=a
	# Check for common fibre position file error
	
	if(i!=1){
		if( fibres[i]==fibres[i-1] ){
		  print("moscal: WARNING! Fibre label ", fibres[i], 
	                "appears to be")
		  print("moscal: in the configuration file twice!")
		  print("moscal: THINGS ARE GOING TO GO WRONG SOON!")
		  print("moscal: The program is still running to help")
		  print("moscal: you figure out which file it should be.")
	          print("moscal: Note ", fibres[i], "is the fibre label ",
			"and not necessarily the slit position.")
		  beverbose=1
		}
	}
	#print("i ",i,"found at position ",fibres[i])
  i+=1
  if(i>=1000){
	     error(11,"Array for positions found run out of room!")
  }

}

numexpected=i-1
print(numexpected, "fibres expected in the data set")

# Find out the slit position -> fibre label mapping
# (fibres 222 and 2115 added to mess things up for the AAT config!)

tempfile3=mktemp("_temp3_")
tprint(p_name,>tempfile3)

in=tempfile3
i=1
# skip the 5 lines of text at the top of the file
for(j=1; j<=5; j+=1){
	answer=fscanf(in,"%s",junk)
}

while(fscan(in,unwanted,a,b)!=EOF){
	slit_pos[i]=a
	fibre_label[i]=b
	#print("i ",i,"found at position ",slit_pos[i],fibre_label[i])
  i+=1
  if(i>=1000){
	     error(11,"Array for positions found run out of room!")
  }

}

numtotal=i-1
print(numtotal, "fibres in slit according to image header")

if(p_review){
	beverbose=1
}


# Figure out the expected positions of the fibres on the detector
# now that know the labelling scheme and the fibres that
# where used in the observation.

# fibres array has the fibre labels that were in this observation
# fibre_label relates this to position in slit slit_pos

tempfile4=mktemp("_temp4_")
count=1
for(i=1; i<=numexpected; i+=1){

	for(j=1; j<=numtotal; j+=1){

		if( fibres[i]==fibre_label[j] ){
			print(slit_pos[j],>>tempfile4)
			#slit_obs[count]=slit_pos[j]
			#print("Fibre ",fibres[count]," is at slit position ",
		      	#slit_obs[count])
			count+=1
		next
		}

	}

}

if ( (count-1) != numexpected ){
	print("moscal: ERROR! Could not match up fibre labels")
	print("moscal: to a position in the slit!")
	bye
}

print((count-1),"fibre positions matched with labels")

tempfile5=mktemp("_temp5_")
sort("-n", tempfile4, >tempfile5)

in=tempfile5
i=1
while(fscan(in,a)!=EOF){
	slit_obs[i]=a
	#print("Fibres on detector are ",slit_obs[i])
  i+=1
  if(i>=1000){
	     error(11,"Array for positions found run out of room!")
  }

}

print("Assuming that first and last fibre on detector were found")
# Guess the solution from above assumption
m=(slit_obs[numexpected]-slit_obs[1])/(ymeas[numfound]-ymeas[1])
c=slit_obs[numexpected] - m*ymeas[numfound]

mslit=(slit_obs[numexpected]-slit_obs[1])/(yref[ slit_obs[numexpected] ] -
       yref[ slit_obs[1] ])
#cslit

print("m data = ", m, "m slit reference = ", mslit)

# Convert the found fibre positions to fibre numbers
# Need to compare with position file as mapping isn't
# exactly linear.
temp=1 # to keep scan happy

# First fibre assumed to be correct
ymeas_pos_id[1]=slit_obs[1]
test_pos=2
for(i=2; i<=numfound; i+=1){

	if(beverbose==1){

		realpos=m*ymeas[i]+c
		print(realpos) | scanf("%d",temp)
		if( (realpos - temp) >= 0.5 ){
	
			print("Guess at slit position is ", (temp+1))	
#			ymeas_pos_id[i]=temp+1
	
		} else {

			print("Guess at slit position is ", temp)	
#			ymeas_pos_id[i]=temp
	
		}

	}

	foundit=0
	# offset should be close to 1
	while( foundit==0 ){

		if(test_pos == (numexpected+1)){
			print("moscal: ERROR! Could not match up found fibre ",
			  "positions with")
			print("moscal: those expected for the observation.")
			print("moscal: Either the centring did not work well")
			print("moscal: - try adjusting sigma and noise,",
		              " or you've")
			print("moscal: chosen the wrong flat field image for ",
			      "the data.")
			print("moscal: There may be more information ",
                              "available if you scroll up!")
			if(!p_review){
				print("moscal: switching on review was also")
				print("moscal: dump more info to the screen.")
			}
			bye
		}
		offset = ( (yref[ slit_obs[test_pos] ] - 
                            yref[ ymeas_pos_id[i-1] ]) /
	                   (ymeas[i] - ymeas[i-1]) ) *
                         (mslit/m)

		if(beverbose==1){
		print("Trying fibre label ", 
		      fibre_label[ slit_obs[test_pos] ], 
		      "with slit position ", slit_obs[test_pos], 
		      "at ymeas ", ymeas[i], "offset is ",offset)
		}
		
		if( (offset > 0.8) && (offset < 1.2) ){
			foundit=1
		}

		ymeas_pos_id[i]=slit_obs[test_pos]
		test_pos+=1

	}
	
	if(beverbose==1){
		print("Fibre at ", ymeas[i], "has position ", ymeas_pos_id[i])
	}
	
	# Check that a found fibre should be there
	# - stab at checking the fibre positions and
	# approximating mapping are correct.
	#matched=0
	#k=i # slit_obs is sorted, so can always start at at least i
	#while(matched==0){
	#	if(k==numexpected+1){
	#		print("Looking for fibre ",ymeas_pos_id[i])
	#		print("moscal: ERROR! The guess at the fibre ID's")
	#		print("moscal: assuming that the 1st and last fibre")
	#		print("moscal: were on the detector failed! Either")
	#		print("moscal: the centring did not work well - try")
	#		print("moscal: adjusting sigma and noise, or you've")
	#		print("moscal: chosen the wrong flat field image for")
	#		print("moscal: the data.")
	#		bye
	#	}
	#	if(ymeas_pos_id[i] == slit_obs[k]){
	#		#print("i= ",i," Found a match!")
	#		matched=1
	#	}
	#	k+=1
	#}

	#print("ypos ",ymeas[i], "is at ",m*ymeas[i]+c, "possible id is: ",ymeas_pos_id[i])

}

tempfile6=mktemp("_temp6_")

# Make up a file so that the data can be fitted
for(i=1; i<=numfound; i+=1){

	print(yref[ ymeas_pos_id[i] ], ymeas[i],>>tempfile6)

}

if(p_review){
	lsqfit(tempfile6)
}

polyfit(tempfile6,1,weighting="uniform",l-) | scan(cfit,mfit,errcfit,errmfit)
print("Fit parameters are m=",mfit,"c=",cfit)

# Do the tracing, this could incorporate the above, but program
# developed by coding the above first!

print("Tracing the fibres")
tempfile7=mktemp("_temp7_")
losttraces=mktemp("_another_temp_file_")

# Keep scan happy!
a0=0
a1=0
a2=0

for(i=1; i<=numfound; i+=1){
	realpos=(mfit*yref[ ymeas_pos_id[i] ])+cfit
	#print("realpos = ",realpos, "ymeas = ",ymeas[i])
	peaktrace(p_name, tempfile7, line, realpos, p_width, p_sigma, 
	          p_noise,>>losttraces)
	#tvmark(frame=1, coords=tempfile7, logfile="", autolog-, outimage="", 
	#      deletions="", commands="", mark="point", color=204, pointsize=1)
	polyfit(tempfile7,2,weighting="uniform",l-) | scan(a0,a1,a2,s0,s1,s2)
	coeffarray[i,1]=a0
	coeffarray[i,2]=a1
	coeffarray[i,3]=a2
	delete(tempfile7)
	delete(losttraces)
}
print("Finished tracing the fibres")

# So now have a0, a1 and a2 for every fibre

for(i=1; i<=numfound; i+=1){
	print(yref[ ymeas_pos_id[i] ], coeffarray[i,1],>>"a0")
	print(yref[ ymeas_pos_id[i] ], coeffarray[i,2],>>"a1")
	print(yref[ ymeas_pos_id[i] ], coeffarray[i,3],>>"a2")
}

# Keep scan happy!

cterms_a0=0 
cterms_a1=0 
cterms_s0=0
cterms_s1=0
xterms_a0=0
xterms_a1=0
xterms_s0=0
xterms_s1=0
x2terms_a0=0
x2terms_a1=0 
x2terms_s0=0
x2terms_s1=0

polyfit("a0",1,weighting="uniform",l-) | scan(cterms_a0,cterms_a1,
					    cterms_s0,cterms_s1)
print("c terms fit parameters are m=",cterms_a1,"c=",cterms_a0)

polyfit("a1",1,weighting="uniform",l-) | scan(xterms_a0,xterms_a1,
					    xterms_s0,xterms_s1)
print("x terms fit parameters are m=",xterms_a1,"c=",xterms_a0)

polyfit("a2",1,weighting="uniform",l-) | scan(x2terms_a0,x2terms_a1,
					    x2terms_s0,x2terms_s1)
print("x2 terms fit parameters are m=",x2terms_a1,"c=",x2terms_a0)

for(i=1; i<=numtot; i+=1){
#	print(((mfit*yref[i])+cfit),"3 0 ",((mfit*yref[i])+cfit),
#	      >> p_outfile)
	
	print(((mfit*yref[i])+cfit),"3 2 ",
	      ((cterms_a1*yref[i])+cterms_a0),
	      ((xterms_a1*yref[i])+xterms_a0),
	      ((x2terms_a1*yref[i])+x2terms_a0),
	      >> p_outfile)

}

# Display the solutions
imgets(p_name//"[sci,1]", "naxis1")
imsizex = int(imgets.value)

#if(p_review){

	for(i=1; i<=numtot; i+=5){

		for(j=1; j<=imsizex; j+=1){

			a0=(cterms_a1*yref[i])+cterms_a0
			a1=(xterms_a1*yref[i])+xterms_a0
			a2=(x2terms_a1*yref[i])+x2terms_a0

			print(j,(a0+a1*j+a2*j*j),>>tempfile7)

		}

	tvmark(frame=1, coords=tempfile7, logfile="", autolog-, outimage="", 
       	deletions="", commands="", mark="point", color=204, pointsize=1)
	
	delete(tempfile7)

	}
#}

delete(tempfile)
delete(tempfile2)
delete(tempfile3)
delete(tempfile4)
delete(tempfile5)
delete(tempfile6)
delete("a0")
delete("a1")
delete("a2")

end


