# cmefarith.cl
#
# Iraf wrapper to cirparith for doing image arithmetic or cirpass
# MEF files
#
# AJ Dean, 17th Jan, 2001

procedure cmefarith(image1,operator,image2,outputimage)

string image1 {prompt="operand1"}
string operator{prompt="operator", enum="+|-|*|/"}
string image2 {prompt="operand2"}
string outputimage {prompt="output image name"}
bool overw     {mode="l", prompt="overwrite output file?"}

begin

	string im1, im2, op, outim, tempfile
	int len
	bool over,exist, doreplace

	im1=image1
	op=operator
	im2=image2
	outim=outputimage
	doreplace=no
	
	# check for .fits on the end of filenames
	len=strlen(im1)
        if(substr(im1,len-4,len)!=".fits") {
                im1=im1//".fits"
        }
	len=strlen(im2)
        if(substr(im2,len-4,len)!=".fits") {

		#this one could be a number and not an image
		exist=access(im2//".fits")
		if(exist){
               		im2=im2//".fits"
		} # else we have a number so do nothing
        }
	
	len=strlen(outim)
        if(substr(outim,len-4,len)!=".fits") {
                outim=outim//".fits"
        }	 

	# check if file already exists
	exist=access(outim)
	if(exist){

		# maybe outim is the same as im1
		if(im1==outim){

			doreplace=yes
			tempfile=mktemp("__temp__")
			tempfile=tempfile//".fits"
			outim=tempfile

		} else {
		
			print("!!!!! output file exists !!!!!")
			over=overw
			if(over){ 
	  	
				delete(outim)
		
			} else {
			
				print("You'll need to pick a different output name!")
				bye
		
			}
		}

	}

	cirparith(im1,"\""//op//"\"",im2,outim)
	
	if(doreplace){
		delete(im1)
		fitsutil
		fxcopy(outim,im1,groups="",new_file+, >& "dev$null")
		delete(outim)
	}

end




