# lensoffset.cl
#
# Determines the lens offsets on the IFU given telescope RA and Dec offsets
#
# A. J. Dean 19th March, 2003
#
# A reverse engineering of ifuoffset.cl


procedure lensoffset(RAoff, DECoff)

real RAoff {prompt="RA offset"}
real DECoff {prompt="DEC offset"}
real lens_scale {mode="lh",prompt="Size of one lens (arcseconds across flats)"} 
real pos_angle {mode="lh",prompt="Position angle of telescope (degrees)"}
real theta_off_N {mode="lh",prompt="Angle between IFU axis and N for PA=0 (degrees)"}
int PA_direction {mode="lh",prompt="Position angle direction from North 1=anticlockwise, 2=clockwise"}
bool dodrawcompass {no, mode="lh", prompt="Draw compass arrows onto display window"}

struct *in {mode="h"}

begin

real scale # IFU lens size across flats
real PA # Position Angle
real theta # Offset angle
int direction # PA direction from north
bool docompass # Draw an arrow onto the display

real offx,offy # x,y offset between lenses

real offRA, offDEC # transformed RA and DEC offsets

real pi=3.1415927

real phi_deg # angle between IFU axis and north degrees
real phi_rad # angle between IFU axis and north radians

real IFU_size_x
real IFU_size_y

real xshift
real yshift
real rotangle

int lens,x,y,gotit # variables for reading in from file

bool exist

char dirRA
char dirDEC

IFU_size_x=(1.0/2.0) # Hexagons
IFU_size_y=sqrt(3.0)/2.0

PA=pos_angle
scale=lens_scale

print("")
print ("The current PA is ", PA,"degrees")
print("The current lens scale is ", scale,"arcseconds per lens")
print("")

offRA=RAoff
offDEC=DECoff

theta=theta_off_N
direction=PA_direction
docompass=dodrawcompass

if(docompass){
	# Check if stsdas is there
		if (!defpac ("stsdas")) {
			stsdas(motd=no)
		}	
}

if(direction==1){
	phi_deg=theta+PA
} else {
	phi_deg=theta-PA
}

phi_rad=(phi_deg/360.0) * 2.0 * pi

xshift=-1*offDEC*cos(phi_rad)-1*offRA*sin(phi_rad)
yshift=offDEC*sin(phi_rad)-1*offRA*cos(phi_rad)

offx=xshift/(IFU_size_x*scale)
offy=yshift/(IFU_size_y*scale)

if(direction==1){
	phi_deg=theta+PA
} else {
	phi_deg=theta-PA
}

print("\n********************************************************")
print("NB, there are 2 lens units per lens along the long axis,")
print("one at lens centres and one at lens edges")
print("********************************************************\n")

# Sort out the rounding up / down to an integer in the print statement

if(offx < 0.0){
offx=offx-0.5
}
if(offx > 0.0){
offx=offx+0.5
}
if(offy < 0.0){
offy=offy-0.5
}
if(offy > 0.0){
offy=offy+0.5
}

printf("Offset in lens units along the long axis, x = %d\n",offx)
printf("Offset in lens units along the short axis, y = %d\n",offy)

if(docompass){

	if(direction==1){
		rotangle=90+theta+PA
	} else {
		rotangle=90+theta-PA
	}		
		
	compass(input="ifuimage[sci,1].fits", output="ifuimage[sci,1].fits",
		xpos=256,ypos=450, angle=rotangle,frame=2, verb-)
	display("ifuimage[sci,1]",frame=2)

}

end



