# fibcal.cl  
#
# Intended to be run on calibration fibre image. Locates the fibres, 
# identifies them, finds their location at various places across the image
# and determines their curvature.
#
# fibtrace.cl in dead code is the original version of this using fitprofs
#
# AJD 28/10/01
#
# This is a bit messy and should really be rewritten sensibly, but it
# works!

procedure fibcal(name,in_reffile,in_outfile,in_noise,in_sigma,in_minsep,in_fib1, in_fib2, in_width, in_review)

string name {prompt="Name of calibration fibre image"}
string in_reffile {prompt="Name of file containing reference fibre positions"}
string in_outfile {prompt="Name of file to contain the new position information"}
bool overw     {mode="l", prompt="overwrite output file?"}
int in_noise   {prompt="background noise in image"}
int in_sigma   {prompt="sigma above background which indicates a line"}
int in_minsep  {prompt="Minimum separation between fibres"}
int in_fib1    {prompt="1st calibration fibre on the detector"}
int in_fib2    {prompt="2nd calibration fibre on the detector"}
int in_width   {prompt="max area around fibre to search for peak"}
bool in_review {prompt="View the 1st set of peaks found?"}
real in_fibfwhm {1.5, prompt="Full width half maximum of a fibre trace (written to fibpos.list)"}


struct *in {mode="h"}

begin

string p_name, p_outfile, tempfile, tempstr, tempfile2
string outfile, tempim, datatofit, tempout, losttraces
string reffile
int linearray[50]
int line, tempdata
int medwidth
int numlines, width
int available_calfibs[0:5]=23,55,96,122,312,424 
int numcalfib=6 # Mirrors array above!
real data[6,50] # 7 is for calfibs, 50 mirrors linearray above
int fibgot[0:5]=6(0)
real fibloc[0:5]=6(0)
real calref[0:5]=6(0)
real yref[508]
int maxsep=20 # spacing for guessing which fibres we have
struct tempstruct
real junk, y, r1, r2, fwhmreal 
int i, num, p_initpos, j
int  noise,sigma,minsep,len, p_frame
bool exist, over, review

real avshift, fibfwhm, centre
real fibpos[0:51]=52(0)
real ypos[0:50]
real pos[508]
real fwhm[0:51]=52(0)
real yrel[508]
real ymidnew[508]
string therest[508]
real newpos[508]

int fib1, fib2, count, numgot
real crudem, crudec, offset
real m, c, errm, errc
real m1, c1, errm1, errc1
real m2, c2, errm2, errc2

real a0,a1,a2,s0,s1,s2
real coeffarray[3,50] # 50 is the max number of input lines
real fibcoeffs [2,508]
real tempreal

p_name=name
reffile=in_reffile
outfile=in_outfile

# check if file already exists
exist=access(outfile)
if(exist){
		print("!!!!! output file exists !!!!!")
		over=overw
		if(over){ 
	  		delete(outfile)
		} else {
			print("You should probably pick a different name!")
		

		}
	}

noise=in_noise  
sigma=in_sigma  
minsep=in_minsep
fib1=in_fib1
fib2=in_fib2
width=in_width
review=in_review
fibfwhm=in_fibfwhm

##load required packages
utils

# check for .fits on the end of input image file

        len=strlen(p_name)
        if(substr(p_name,len-4,len)!=".fits") {
                p_name=p_name//".fits"
        }

tempout=mktemp("__tempout__")
# median the input image
medwidth=11
median(p_name//"[sci,1]",tempout,medwidth,1)

# display the calibration fibre image
p_frame=4
display(tempout,p_frame)

tempfile=mktemp("temp")

#Use the middleish line in peakfind

line=512

print("Making initial stab at peaks using peakfind_sep")
peakfind_sep(tempout//".fits",line,noise,sigma,tempfile,minsep)

#peakcentre just needs the y coordinate so get this out of tempfile 
in=tempfile
i=0
while(fscan(in,y)!=EOF){
  ypos[i]=y
#  print("i ",i,"found at position ",ypos[i])
  i+=1
  if(i>=50){
	     error(11,"Array for lines found run out of room!")
  }

}

num=i

print("Determining which fibres we have")

# Do this first to find out which fibres we have on the clean signal
# that should be present in the centre of the chip

# Accurately locate the peaks by centroiding
centre=0
for(i=0;i<num;i+=1){

	peakcentre(tempout//".fits", line, ypos[i],width,medwidth) | scan(centre)
	fibpos[i]=centre

}

#Output the results
if(review){

	tempfile2=mktemp("__temp2__")
	for(i=0;i<num;i+=1){
	# print("found at ", ypos[i], "centered at ",fibpos[i])
  	print(fibpos[i]," 1.0",>>tempfile2)
	}

	tempim=mktemp("__temp__")
	imcopy(tempout//"["//line//",*]",tempim)
	specmark_no_wav(tempim//".fits",tempfile2)
	imdel(tempim)
	delete(tempfile2)
}

delete(tempfile)

# Find out which fibres we have

# Make a crude guess at the dispersion to find out which fibres we have
crudem=(fib1-fib2)/(fibpos[1]-fibpos[2])
crudec=fib1-crudem*fibpos[1]

# and try to match the fibres up
count=0
while( fib1!=available_calfibs[count] ){
	count+=1
}

fibgot[0]=fib1
fibgot[1]=fib2
fibloc[0]=fibpos[1]
fibloc[1]=fibpos[2]

count=2

for(j=3; j<num; j+=1){

	for(i=0; i<numcalfib; i+=1){
		
		if(count>=numcalfib){
			error(12,"Have matched up too many calibration fibres!\nCheck your sigma and background parameters.\nThis may be easiest using gausspeaks.")
        	}
		
		offset = (crudem*fibpos[j]+crudec) - available_calfibs[i]

		if( (offset < 0) && (offset > (-1*maxsep)) ){
	
			fibgot[count]=available_calfibs[i]
			fibloc[count]=fibpos[j]
			count+=1
			break
	
		} else if ( (offset > 0) && (offset < maxsep) ){
	
			fibgot[count]=available_calfibs[i]
			fibloc[count]=fibpos[j]
			count+=1
			break
		}	
	
	}		

}

numgot=count

for(i=0; i<numgot; i+=1){

	print("Fibres identified are ", fibgot[i], " at ", fibloc[i])

}

# keep scan happy, lovely iraf feature ...
a0=0
a1=0
a2=0
s0=0
s1=0
s2=0
s3=0

datatofit=mktemp("_fitdata_")
losttrace=mktemp("_losttraces_") 

for(j=0; j<numgot; j+=1){

	peaktrace(tempout//".fits",datatofit, line,fibloc[j],width,sigma,noise,>>losttraces)
	
	polyfit(datatofit,2,weighting="uniform",l-) | scan(a0,a1,a2,s0,s1,s2)
	coeffarray[1,j+1]=a0
	coeffarray[2,j+1]=a1
	coeffarray[3,j+1]=a2

	print("Fibre: ",fibgot[j], " Trace = ",a0," + ",a1,"X + ",a2,"X2")

delete(datatofit)
delete(losttraces)
}

# Do the scaling based on the reference fibre data input file

in=reffile
i=1 # Iraf won't let this array run from zero !!!!!
while(fscan(in, tempreal, tempstruct)!=EOF){
	yref[i]=tempreal
#	print(yref[i])
	therest[i]=tempstruct
	i+=1
}
num=i-1
print("num=",num)

# 1st, just the central line for backward compatability
# this goes into column 1 of the position file

# Copied and pasted in from fibcal.cl, hence code duplication below
# Tidy me up!

tempfile=mktemp("_temp_")
for(i=0; i<numgot; i+=1){
	calref[i]=yref[ fibgot[i] ]
	print(calref[i]," ", fibloc[i], >> tempfile)
# 	print("calfibs should be at ",calref[i])
}

# keep scan happy
m=0 
c=0
errm=0
errc=0

# fit a straight line to the data
polyfit(tempfile,1,weighting="uniform",l-) | scan(c,m,errc,errm)
print("At line ", line, " m=",m,"+-",errm," c=",c,"+-",errc)

# create the output array
for(i=1; i<=num; i+=1){

	ymidnew[i]=(m*yref[i])+c

}
delete(tempfile)


# Assume ! that the coordinates found change linearly across the chip
# so find this fit in order to determine how to scale the output data

# The "y" or "c" term - find out where this is in the calibration data 
# and scale and shift appropriately

print("positions")
tempfile=mktemp("_temp_")
for(i=0; i<numgot; i+=1){
	calref[i]=yref[ fibgot[i] ]
	print(calref[i]," ", coeffarray[1,i+1], >> tempfile)
# 	print("calfibs should be at ",calref[i])
	print(calref[i]," ", coeffarray[1,i+1])
}

# keep scan happy, lovely iraf feature ...
m=0 
c=0
errm=0
errc=0
m1=0 
c1=0
errm1=0
errc1=0
m2=0 
c2=0
errm2=0
errc2=0

# fit a straight line to the data
polyfit(tempfile,1,weighting="uniform",l-) | scan(c,m,errc,errm)
print("Positions: m=",m,"+-",errm," c=",c,"+-",errc)

delete(tempfile)

# Fill in the new positions

for(i=1; i<=num; i+=1){
	newpos[i]=(m*yref[i])+c
}

# Now sort out the trace

print("1st order terms")
for(i=0; i<numgot; i+=1){
	printf("%f %f\n", newpos[ fibgot[i] ], coeffarray[2,i+1])
	print(newpos[ fibgot[i] ]," ", coeffarray[2,i+1], >> tempfile)
}
# fit a straight line to the data
polyfit(tempfile,1,weighting="uniform",l-) | scan(c1,m1,errc1,errm1)
print("1st order: m=",m1,"+-",errm1," c=",c1,"+-",errc1)

delete(tempfile)

print("2nd order terms")
for(i=0; i<numgot; i+=1){
	printf("%f %f\n", newpos[ fibgot[i] ], coeffarray[3,i+1],)
	print(newpos[ fibgot[i] ]," ", coeffarray[3,i+1], >> tempfile)
}
# fit a straight line to the data
polyfit(tempfile,1,weighting="uniform",l-) | scan(c2,m2,errc2,errm2)
print("2nd order: m=",m2,"+-",errm2," c=",c2,"+-",errc2)

delete(tempfile)

# create the output file

for(i=1; i<=num; i+=1){

	printf("%f %f 2 %f %f %f\n", ymidnew[i], fibfwhm, newpos[i], 
		(m1*newpos[i])+c1, (m2*newpos[i])+c2, >> outfile)

#	print(newpos[i], " 1.5 2 ",  newpos[i], (m1*newpos[i])+c1,"0 ", 
#	      >> outfile)

#	print(newpos[i], " 1.5 2 ",  newpos[i], (m1*newpos[i])+c1," ",  
#		(m2*newpos[i])+c2, >> outfile)

}

# Mark the lines found on the display

tempfile2=mktemp("__temp2__")
for(i=0;i<numgot;i+=1){

  	print(fibgot[i],>>tempfile2)

}

showtrace(tempfile2,outfile,frame=p_frame)
delete(tempfile2)
imdelete(tempout)

end

###############################################################################
# Experimental interpolation code

#for(i=1; i< fibgot[0]; i+=1){

#	fibcoeffs[1,i]= (( newpos[i] - newpos[ fibgot[0] ]  )*m) + 
#			coeffarray[2,1] 

#}

#for(j=0; j<numgot-1; j+=1)

#	for(i=fibgot[j]; i<fibgot[j+1]; i++)

#		fibcoeffs[1,i]= 
#			(( newpos[ fibgot[j+1] ] - newpos[ fibgot[j] ])) 
#			+ coeffarray[2,j+1]








