###############################################################################
# task extract1
#
# Task to use IRAF apsum to extract spectra, but to have input and
# output MEF files.
#
###############################################################################

procedure extract1(im,out,dbase,ref)

string im {prompt="MEF file containing spectra to be extracted (must have extension)"}
string out {prompt="MEF file to contain output extracted spectra"}
string dbase {prompt="Name of IRAF database file"}
string ref {prompt="Name of image used to define apertures and trace"}

struct *in

begin
string p_im,p_out,p_dbase,p_ref,tempfile,imroot,phead,imext1
string tempfile1,ext,fitsname,insext
int len,pos,junk,prevext
struct values,therest

p_im=im
p_out=out
p_dbase=dbase
p_ref=ref

###########CHECKS##########################
#check that input image has an extension 
len=strlen(p_im)
if(substr(p_im,len,len)!= "]")
  error(10,"Input MEF file must have extension specified")

#check that the output file doesn't exist 
if(access(p_out))
  error(10,"Output file already exists")
  
###########REQUIRED VARIABLES

#make temporary file to contain apsum output ms file
tempfile=mktemp("temp")

pos=stridx("[",p_im)-1
imroot=substr(p_im,1,pos)

##call apsum to extract summed spectra with no sky subtraction
apextract.database=p_dbase #set database file
apsum(p_im,output=tempfile, apertures="", format="multispec",references=p_ref, profiles="", interactive=no,find=no, recenter=no, resize=no, edit=no, trace=no, fittrace=no, extract=yes,extras=no, review=no, line=INDEF, nsum=10, background="none", weights="none",pfit="fit1d", clean=no, skybox=1, saturation=INDEF, readnoise="30",gain="21960", lsigma=4., usigma=4., nsubaps=1)
print("Extraction done")
tempfile=tempfile//".fits" #apsum adds a fits on the end
##NB apsum seems to remove extname and extver from the extension header when
##it creates the header for tempfile

##make output MEF image
#copy primary header unit from input file
print("copying primary header")
fxcopy(imroot,p_out,groups=0,new_file=yes)


#if the 1st extension in the input file is a binary table extension
#then copy it
#this is a nasty way of checking if the 1st extension is a binary table
#extension
imext1=imroot//"[1]"
tempfile1=mktemp("temp")
print(" tempfile1 ",tempfile1)
catfits(imext1,>tempfile1)
#read the last line into values
in=tempfile1
while(fscan(in,values)!=EOF){}
junk=fscan(values,ext,fitsname,therest)
print(" fitsname ",fitsname)
prevext=0 #this is the number of the last extension in p_out
insext=p_out//"["//prevext//"]" #extension to insert after
if(fitsname == "BINTABLE"){
  print("copying binary table extension")
  fxinsert(imext1,insext) 
  prevext+=1
}

#insert the temp .ms file into the next extension
insext=p_out//"["//prevext//"]" #extension to insert after
fxinsert(tempfile,insext,0)
#add extname=sci, extver=1 to this extension
prevext+=1
hedit(p_out//"["//prevext//"]","EXTNAME","SCI",add+,delete-,verify-,show-)
hedit(p_out//"["//prevext//"]","EXTVER","1",add+,delete-,verify-,show-)

##ADD need var,dq,time extensions in the final file

end
