# doflat.cl script for flat field observations,
# to give total raw, ima counts and an image histogram
#
# A.J. Dean 8th Jan, 2002.

procedure doflat(name,run_no,dateobs,stackno)

string name {prompt="Root name"}
string run_no {prompt="Run no."}
string dateobs {prompt="Date of observations"}
string stackno {prompt="Stack the n'th read of every loop, all or av (average)"}
#string configfile {"CIRPBIN$../IFUdat/cirpass.cfg", prompt="File containing IFU fibre configuration info"}

begin


	string fname, frunno, fdateobs, fstackno, imaoutroot, imaout, fcfgfile
	string posfile, rawout
	int inc
	real imacounts, rawcounts

	fname=name
	frunno=run_no
	fdateobs=dateobs
	fstackno=stackno
#	fcfgfile=configfile

	docirpass(name=fname,run_no=frunno,dateobs=fdateobs,stackno=fstackno)
                #  configfile=fcfgfile)

	imaoutroot=fname//"_"//frunno//"_ima"
	imaout=fname//"_"//frunno//"_ima.fits"

	inc=1
	while(access(imaout)){
  	imaout=imaoutroot//"."//inc//".fits"
  	inc+=1
	}

	if(inc>2){
		imaout=imaoutroot//"."//inc-2//".fits"
	} else {
		imaout=fname//"_"//frunno//"_ima.fits"
	}

	rawout=fname//"_"//frunno//"_raw.fits"

	imacounts=0
	rawcounts=0

	imstat(imaout//"[sci,1][*,200:800]",fields="midpt",format-) | 
		scan(imacounts)

	imstat(rawout//"[sci,1][*,200:800]",fields="midpt",format-) | 
		scan(rawcounts)

	print("Median counts in central section of raw file = ",rawcounts)
	print("Median counts in central section of ima file = ",imacounts)

	imhist(rawout//"[sci,1]",z1=0, z2=16500)

	run_no=frunno+1

end
