###############################################################################
# task _logic_check
#
# Hidden task which checks the logic of data reduction header keywords.
# If a kword which drives the data reduction is set then this task
# checks that the required calibration files exist.
# It does NOT check that they have the correct format.
#
# RAJ 18.8.00
#
# The parameters zoffchk,bkgchk etc are used to decide which data
# reduction keywords have their logic checked. 
# The values of the data reduction keywords are inputs to the task.
# 
# Currently written - zoffchk, bkgchk
#
# NOTE at the moment have to set all parameters (eg zoffcorr) to something
# in the calling task, otherwise it prompts for them. I can't figure
# out how to set the parameters to something in this task.
# Tried eg string zoffcorr {"notset",mode="h"} but this doesn't work
###############################################################################

procedure _logic_check

string targetname {"notset",mode="h"}
int nexn {0,mode="h"}
string zoffcorr {mode="h"},maskcorr {mode="h"},noiscalc {mode="h"},timecalc {mode="h"},lincorr {mode="h"},unitcorr {mode="h"},cridcalc {mode="h"},bkgcorr {mode="h"},doextr {mode="h"}, dowvcal {mode="h"},dowvalgn {mode="h"},flatcorr {mode="h"},doflcal {mode="h"},maskfile {mode="h"},noisfile {mode="h"},linfile {mode="h"},bkgfile {mode="h"},extrfile {mode="h"},dbfile {mode="h"},wvfile {mode="h"},flatfile {mode="h"},calfile {mode="h"}

bool zoffchk {no,mode="h"},maskchk {no,mode="h"},noischk {no,mode="h"},timechk {no,mode="h"},linchk {no,mode="h"},unitchk {no,mode="h"},cridchk {no,mode="h"},bkgchk {no,mode="h"},extrchk {no,mode="h"},wvcalchk {no,mode="h"},wvalgnchk {no,mode="h"},flatchk {no,mode="h"},flcalchk {no,mode="h"}

struct outlogic

begin
string exth,targetph,sub
int zext,totexn,nread,zread,len,pos,tableext
real curr_read # stack writes this as a float not an int AJD GEMINI-S change
real rnexn
bool zofflgc,masklgc,noislgc,timelgc,linlgc,unitlgc,cridlgc,bkglgc
bool extrlgc,wvcallgc,wvalgnlgc,flatlgc,flcallgc

#print "in _logic_check\n"

##constant variables
targetph=targetname//"[0]"
##nexn is number of extensions per imset, passed in parameter set
##rnexn is real version
rnexn=real(nexn)

#print("in logic check, nexn = ",nexn, " zoffcorr = ", zoffcorr)

#############checking logic of data reduction keywords#########################
#set up logicals for data reduction driving keywords
zofflgc=(zoffcorr == "perform") || (zoffcorr == "PERFORM")
masklgc=(maskcorr == "perform") || (maskcorr == "PERFORM")
noislgc=(noiscalc == "perform") || (noiscalc == "PERFORM")
timelgc=(timecalc == "perform") || (timecalc == "PERFORM")
linlgc=(lincorr == "perform") || (lincorr == "PERFORM")
unitlgc=(unitcorr == "perform") || (unitcorr == "PERFORM")
cridlgc=(cridcalc == "perform") || (cridcalc == "PERFORM")
bkglgc=(bkgcorr == "perform") || (bkgcorr == "PERFORM")
extrlgc=(doextr == "perform") || (doextr == "PERFORM")
wvcallgc=(dowvcal == "perform") || (dowvcal == "PERFORM")
wvalgnlgc=(dowvalgn == "perform") || (dowvalgn == "PERFORM")
flatlgc=(flatcorr == "perform") || (flatcorr == "PERFORM")
flcallgc=(doflcal == "perform") || (doflcal == "PERFORM")

########read required keywords for checking from primary header##############
hselect(targetph,"NEXTEND",yes) | scan(totexn)
hselect(targetph,"NREADS",yes) | scan(nread)

########check logic for required parameters and reset logicals###############
##first check if this file contains a table extension. if it does
##then set tableext=1
tableext=0
##totexn contains total number of extensions
##if totexn is divisible by 4 then there is no table extension,
##otherwise there is
if(int(totexn/rnexn)!=totexn/rnexn)
  tableext=1

if(zoffchk){
  if(zofflgc){
##check that input file contains the zeroth read
##from primary header read number of reads per loop from NREADS
##zeroth read is in science extension with loop=1,read=NREADS
##or alternatively with current read=NREADS    
##check that a science extension with current read=NREADS exists
##in the input file
##go through each science extension and find the one with CURR_NDR=nread-1
##(because curr_ndr is numbered from 0
    print("LOGIC_CHECK: zoffchk")
    zread=nread-1
    print("Zeroth read is in read ",zread," (Note reads are numbered from 0)")
    zext=-100
    for(i=1+tableext;i<=totexn;i+=nexn){
      exth=targetname//"["//i//"]"
      hselect(exth,"CURR_NDR",yes) | scan(curr_read)
      if(curr_read==zread)
        zext=i
    }
    if(zext==-100){
      print("Zeroth read loop 0, read ",nread," is not in ",targetname)
      print("Zeroth read subtraction will be OMITTED")
      zofflgc=no
    }
    else{
      print("Zeroth read is in extension ",zext)
    }
  }
}

if(maskchk){
  if(masklgc){
    print("LOGIC_CHECK: Sorry maskchk isn't written yet")
  }
}

if(noischk){
  if(noislgc){
    print("LOGIC_CHECK: Sorry noischk isn't written yet")
  }
}

if(timechk){
  if(timelgc){
    print("LOGIC_CHECK: Sorry timechk isn't written yet")
  }
}

if(linchk){
  if(linlgc){
    print("LOGIC_CHECK: Sorry linchk isn't written yet")
  }
}

if(unitchk){
  if(unitlgc){
    print("LOGIC_CHECK: Sorry unitchk isn't written yet")
  }
}

if(cridchk){
  if(cridlgc){
    print("LOGIC_CHECK: Sorry cridchk isn't written yet")
  }
}

if(extrchk){
##if doextr if perform then check that extrfile exists
##if it doesn't exist then set extrlgc=0 and print warning
  if(extrlgc){
    print("LOGIC_CHECK: extrchk")
    if((!access(extrfile)) || (extrfile=="notset")){
       extrlgc=no
       print("##################WARNING!############################")
       print("Spectral extraction is set to PERFORM but required")
       print("calibration file ",extrfile," does not exist.")
       print("Spectral extraction will be OMITTED.")
       print("######################################################")      
    }
  }
}

if(bkgchk){
##if bkgcorr is perform then check that bkgfile exists
#if it doesn't exist then set bkglgc=0 and print warning
  if(bkglgc){
    print("LOGIC_CHECK: bkgchk")
    if((!access(bkgfile)) || (bkgfile=="notset")){
      bkglgc=no
      print("##################WARNING!############################")
      print("Background correction is set to PERFORM but background")
      print("file does not exist.")
      print("Background correction will be OMITTED.")
      print("######################################################")
    }
  }
}

if(wvcalchk){
  if(wvcallgc){
    print("LOGIC_CHECK: Sorry wvcalchk isn't written yet")
  }
}

if(wvalgnchk){
  if(wvalgnlgc){
    print("LOGIC_CHECK: Sorry wvalgnchk isn't written yet")
  }
}

if(flatchk){
##if flatcorr is perform then check that flatfile exists
#if it doesn't exist then set flatlgc=0 and print warning
  if(flatlgc){
    print("LOGIC_CHECK: flatchk")	
    if((!access(flatfile)) || (flatfile=="notset")){
      flatlgc=no
      print("##################WARNING!############################")
      print("Flatfield correction is set to PERFORM but flatfield")
      print("file does not exist.")
      print("Flatfield correction will be OMITTED.")
      print("######################################################")
    }
  }
}

if(flcalchk){
  if(flcallgc){
    print("LOGIC_CHECK: Sorry flcalchk isn't written yet")
  }
}

###################get final logical values
##final values are in struct outlogic which is a hidden paramter for the task
##so can be seen from other tasks as _logic_check.outlogic
outlogic=zofflgc//" "//masklgc//" "//noislgc//" "//timelgc//" "//linlgc//" "//unitlgc//" "//cridlgc//" "//bkglgc//" "//extrlgc//" "//wvcallgc//" "//wvalgnlgc//" "//flatlgc//" "//flcallgc

end


