
% Generates a graph showing OH lines, atmospheric transmission
% and the J and H pass bands.

% Get data

load Isaac_bright_oh.dat;
ohx=Isaac_bright_oh(:,1);
ohy=Isaac_bright_oh(:,2);

load atmosphere.dat;
atmosx=atmosphere(:,1);
atmosy=atmosphere(:,2);

% Draw graphs

graphout=plot(atmosx,atmosy,'b');
hold on;

% Set the scaling of the oh lines and plot them

ohynorm=ohy.*(0.8/max(ohy));
SX=stem(ohx,ohynorm,'r');
set(SX,'Marker','none');

axis([1,1.9,0,1.3]);
%title('Characteristics of the atmosphere in the infrared');
xlabel('Wavelength (\mu{m})');
H=[graphout,SX(2)];
legend(H,'Atmospheric transmission','OH line intensities (normalised to 0.8)');

% Draw on the J and H band arrows

text(1.0,1.1,'\leftarrow');
text(1.175,1.1,'J band','HorizontalAlignment','center');
text(1.35,1.1,'\rightarrow','HorizontalAlignment','right');

text(1.45,1.1,'\leftarrow');
text(1.625,1.1,'H band','HorizontalAlignment','center');
text(1.8,1.1,'\rightarrow','HorizontalAlignment','right');

hold off;

% Save to output file
saveas(graphout,'atmosphere.eps','epsc2');

