/* Reads in a fits file, and counts the number of times an individual bit
** is on in the data, and plots the output
**
** A. J. Dean 12th Dec, 2000
**
*/

#define NBITS 14

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "fitswrap.h"
#include "cpgplot.h"      /* for the graphics output */

int power(int num, int power);

int main(int argc, char* argv[])
{

  int i=0;
  int j=0;
  int* total_on=NULL;
  float* data;
  int bitpix;
  long axes[2];
  int imsize=0;
  char* outputdevice=NULL;       /* output device */

  /* Check for appropriate input */
  if (argc < 2) {
    fprintf(stderr, 
	    "Usage: %s file_to_be_bit_counted [output.ps]\n", 
	    argv[0]);
    exit(1);
  }

  if ( argc == 3 ){
 
    if ( (outputdevice=(char *)malloc((strlen(argv[2])+4)*sizeof(char))) 
	 == NULL ){
      
      printf("plot: memory allocation for output file failed\n");
      exit(1);
      
    }
    
    strcpy(outputdevice,argv[2]);
    strcat(outputdevice,"/PS");
    
  } else if ( argc == 2 ){
    
    if ( (outputdevice=(char *)malloc(9*sizeof(char))) == NULL ){
      
      printf("plot: memory allocation for output file failed\n");
      exit(1);
      
    }
    
    strcpy(outputdevice, "/xwindow");

  }

  /*  Find out file size */
  readkeys(argv[1],axes, &bitpix);

  /* Read in the fits file */
  data = readfits_float(argv[1], 0);

  /* Allocate memory */
  if ( (total_on=(int *)malloc(NBITS*sizeof(int))) == NULL ){
    
    printf("bit_check: Memory allocation failed");
    exit(1);
  }

  /* Clear out the total_on array */
  for(i=0; i<NBITS; i++){

    *(total_on+i) = 0 ;
  }
  
  /* Loop over image and count up the bits */
  imsize = axes[0] * axes[1];

  for(j=0; j<imsize; j++){
  
    for(i=0; i<NBITS; i++){

      if( ( (int)(*(data+j)) & power(2,i) ) > 0 ){
	*(total_on+i) += 1 ;
      }
      
    }

  }  

  for(i=0; i<NBITS; i++){

    printf("Bit %i had %i occurences\n",i+1,*(total_on+i));

  }

  /* Plot the data in a graph */
  /* Open graphics device. */      
  if(cpgbeg(0, outputdevice, 1, 1) != 1)
    return 1; 
  
  /* Plot the output on screen */
  /* Define coordinate range of graph and draw axes. */
  cpgenv(0, NBITS+1.5, 0, imsize, 0, 0);
 
  /* Label the axes */
  cpglab("Bit", "Number", "Histogram showing frequency of bit occurences in image"); 
  
  cpgsfs(2); /* Outline fill style */

  /*  Plot the line graph. */
  for(i=0; i<NBITS; i++){
    
    if ( i%2 > 0 ){
      cpgsci(4); /* Blue lines */
    } else {
      cpgsci(1); /* White lines */
    }
    
    cpgrect(i+0.5,i+1.5,0,*(total_on+i));   
  }
  
  /* Close the graphics device */
  cpgend();

  free (outputdevice);
  free(data);
  free(total_on);
  return 0;

}


int power(num,power)
{

  int i=0;
  int result=1;
  
  if(power==0){
    return 1;
  }

  for(i=1; i<=power; i++){
    result *= num;
  }

  return result;

}
  





