/* makemef.c
 *
 * Makes a CIRPASS MEF file based on a template header file
 *
 * A J Dean, 11th Feb, 2002.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "fitswrap.h"

int main(int argc, char* argv[])
{

  float* indata=NULL;
  float* data[4];
  float* outzero=NULL;
  char* exts[]={"SCI","VAR","DQ","TIME"};
  long naxes[2];
  int bitpix=0;
  int i=0;

  /* Check for appropriate input */
  if (argc < 4) {
    fprintf(stderr, 
            "Usage: %s reffile.fits infile.fits outputfile.fits\n", 
            argv[0]);
    exit(1);
  }

  /* Read in file */
  indata=readfits_float(argv[2], 0); 
  /* And find out its size */
  readkeys(argv[2], naxes, &bitpix);

  /* Allocate memory */
  if ( (outzero=(float*)malloc(naxes[0]*naxes[1]*sizeof(float))) == NULL ){
    
    printf("makemef: Memory allocation failed!");
    exit(1);
  }

  for(i=0; i<naxes[0]*naxes[1]; i++){
    *(outzero+i)=0;
  }

  data[0]=indata;
  data[1]=outzero;
  data[2]=outzero;
  data[3]=outzero;

  write_cirp_copy_hdu_float(argv[1], argv[3], exts, data, 4, 2, naxes);

  free(indata);
  free(outzero);

  return 0;

}
