#include <stdio.h> /* Standard Input/ Output Library */
#include <stdlib.h>
#include <math.h>

double gaussian(double l1, double l0, double delta) 
{
  //fraser's gaussian.c
  
  double term1, term2, term3; 	// As the Equation is quite big.
  
  term1 = 1.0 / (sqrt(2.0*M_PI) * delta);
  term2 = (l1 - l0)/ delta;
  term3 = -0.5 * pow(term2, 2);
  
  return term1 * pow(M_E, term3);
}



int main()
{

  double peak=528.534;
  double ilow=528.5;
  double ihi=529.5;
  double sigma=0.085;
  double nbin=500.0;

  double tot,lstep;
  double i;

  lstep=(ihi-ilow)/nbin;

  printf("ilow %g ihi %g lstep %g\n",ilow,ihi, lstep);
  printf("%f\n",peak);

  tot=0.0;
  for(i=ilow;i<ihi;i+=lstep){
    tot+=gaussian(peak,i,sigma)*lstep;

    //printf("%g %g\n",i,tot);
  }

  printf("tot %g\n",tot);

  return 0;
}
