/* Cosmic.c driver program to call the cosmic ray removal program cosmicray.c 
** Andrew J. Dean 7th June, 2000.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "cosmicray.h"
#include "cirpass.h"

int main(int argc, char* argv[])
{

  float thresh=0;
  char outfile[FNAMELENGTH];

  if (argc < 2) {
  
      fprintf(stderr, 
          "Usage: %s in.fits [out.fits] [(float)threshold] \n", 
           argv[0]);
        exit(1);
  
  } else if (argc==2){
 
    sprintf(outfile,"!%s",argv[1]);
    printf("cosmic: Output file is %s, input file will be overwritten!!\n",&outfile[1]);
    cosmicray(argv[1],outfile,thresh);
  
  } else if (argc==3){
   
    if ( strcmp(argv[1],argv[2]) == 0 ){
      
      sprintf(outfile,"!%s",argv[1]);

    } else {

      sprintf(outfile,"%s",argv[2]);

    }
    
    printf("cosmic: Output file is %s \n",outfile);
    cosmicray(argv[1],outfile,thresh);
     
  } else if (argc==4){

     if ( strcmp(argv[1],argv[2]) == 0 ){
     
       sprintf(outfile,"!%s",argv[1]);

    } else {

      sprintf(outfile,"%s",argv[2]);

    }
 
    sscanf(argv[3],"%f",&thresh); 
    printf("cosmic: Output file is %s \n",outfile);
    cosmicray(argv[1],outfile,thresh);
    
  } else {

    printf("Too many arguments!\nUsage: %s in.fits [out.fits] [(float)threshold] \n",argv[0]);

        exit(1);
  }

  
  return 0;
}

