# quick cl script to produce a MEF file suitable for
# dotarget from an ordinary image
# 
# A J Dean, 11th Feb, 2002.

procedure makemef(in_reffile, in_inputfile, in_outfile)

string in_reffile {prompt="Reference CIRPASS MEF file"}
string in_inputfile {prompt="File to be added"}
string in_outfile {prompt="File name of output file"}

begin

string reffile, inputfile, outfile, tempfile

# load required packages

fitsutil

tempfile=mktemp("_temp_")
tempfile=tempfile//".fits"

mkpattern(temp, pattern="constant",v1=0,ndim=2,ncols=1024,nlines=1024)

# Make it read ncols and nlines from the input file !!!!!!!!!!!!!!!!

reffile=in_reffile
inputfile=in_inputfile
outfile=in_outfile

fxcopy(reffile, outfile, groups="0,1", new_file=yes)
fxcopy(inputfile, outfile, groups="0", new_file=no)
fxcopy(tempfile, outfile, groups="0", new_file=no)
fxcopy(reffile, outfile, groups="4,5", new_file=no)

delete(tempfile)

end


