/* specsort.c
** 
** Using the fibre configuration info, and the actual extracted spectra
** returns a lens position and it's flux
**
** A J Dean. 10th April, 2001.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include "specsort.h"
#include "cirpass.h"
/* #define DEBUG */

extern float** specsort(float** configdata, int numconfig, float* specdata, 
			int numspec, int* numlenses)
{


  int i=0;
  int lenscount=0;
  float** lensdata=NULL;
  int apnum=0;          /* Index for apsum's extracted aperture number */
  int count=0;          /* Index for lens number */

  /* Find out how many lenses altogether */

  for(i=0; i<numconfig; i++){

    if( *( *(configdata+1) + i) != CALFIBRE){

      lenscount+=1;

    }

  }
  
  *numlenses=lenscount;

  /* Allocate memory for output array */
  
  if ( ( lensdata=(float**)malloc(3*sizeof(float*)) ) == NULL ){
    printf("specsort: Memory allocation failed!");
    exit(1);
  }
  
  for(i=0; i<3; i++){

    if ( ( *(lensdata+i)=(float*)malloc(lenscount*sizeof(float)) ) == NULL ){
      printf("specsort: Memory allocation failed!");
      exit(1);
    }
    
  }

  /* Fill lensdata performing appropriate shifts */
  
  count=0; /* Follows lenses in the IFU */
  apnum=0; /* Follows extracted aperture number */

  for(i=0; i<numconfig; i++){

    if( ( *(*(configdata+1)+i) == CALFIBRE ) ){

      if( ( *(*(configdata+3)+i) != MISSEDDET ) ){

	/* We have an extracted aperture that we don't want */
	
#if defined DEBUG
	printf("have a calibration fibre with apnum %d\n",apnum+1);
# endif
	apnum++;

      } 

    } else { /* We have a lens */

      if ( ( *(*(configdata+3)+i) == MISSEDDET ) ){ 
	
	/* Nothing was extracted (also should test against
	 * NOTINSLIT but these are the same for our config)
	 */

	*( *(lensdata)+count ) = *( *(configdata+1)+i ); 
	*( *(lensdata+1)+count ) = *( *(configdata+2)+i );
	*( *(lensdata+2)+count ) = NOFIBRE;
	
#if defined DEBUG
	printf("have a lens for which nothing was extracted lensnum %d\n",
	       count+1);
# endif
	count++;

      } else {
	
	*( *(lensdata)+count ) = *( *(configdata+1)+i ); 
	*( *(lensdata+1)+count ) = *( *(configdata+2)+i );
	*( *(lensdata+2)+count ) = *( specdata + apnum );
	
#if defined DEBUG
	printf("have a lens with data apnum %d lensnum %d\n",
	       apnum+1, count+1);
# endif
	
	count++;
	apnum++;
	
      }
      
    }
    
  }
  
  return lensdata;
  
}

