/* sortfile.c
**
** Sorts a text file into order
**
** A J Dean. 24th Oct, 2001
**
*/

#include <stdio.h>
#include <stdlib.h>

int main(int argc, char* argv[])
{

  FILE* datafile;
  int   order[1000]={0};
  float data[1000]={0};
  float sortdata[1000]={0};
  int i=0;
  int numgot=0;
  int numfib=508;

  /* Check for appropriate input */
  if (argc < 2) {
    fprintf(stderr, 
            "Usage: %s file_to_sort\n", 
            argv[0]);
    exit(1);
  }
  
  /* Open the input file */
  if ( !(datafile = fopen(argv[1],"r")) ){
    printf("sortfile: Failed to open the input file\n");
    exit(1);
  }
 
  /* Read in the data */
  while ( fscanf(datafile,"%i %f",&order[i],&data[i]) !=EOF ){
    i++;
    if(i==1000){
      printf("sortfile: Have run out of array room! Edit sort.c to fix\n");
      exit(1);
    }
  }

  numgot=i;
 
  for(i=0; i<numfib; i++){
    sortdata[ order[i]-1  ]=data[i];
  }

  for(i=0; i<numfib; i++){
    printf("%i %f\n", i+1, sortdata[i]);
  }
  
  return 0;

}
  
  

