#############################################################################
#
# task secstat
#
# to find statistics of given image section in each science extension
# in MEF file
#
# RAJ 5.9.00
#############################################################################

procedure secstat(im,sec)

string im {prompt="MEF file"}
string sec {prompt="image section eg x1:x2,y1:y2"}

begin

string l_im,l_sec
string imph,imsci,sciname,varname,dqname,timname,imsec
real timeobs[500],smidpt,smode[500],loop,read,currndr,smean,ctssec,sstddev
real gain,elsec,testmode,cts,endtime
int nexn,nimset,i,totexn

##query parameters
l_im=im
l_sec=sec

##hardwired pars should go in package parameters
##hardwired num of extensions per imset
nexn=4
##hardwired header extname for extensions
sciname="SCI"
varname="VAR"
dqname="DQ"
timname="TIME"
##hardwired gain # Removed AJD 7/11/00 -> read from file below
##gain=12.2

imph=l_im//"[0]"

##get number of extension in file
hselect(imph,"nextend","yes") | scan(totexn)

##get gain
hselect(imph,"GAIN","yes") | scan(gain)

##number of imsets
nimset=totexn/nex

print("Image ",l_im)
print("Section ",l_sec)
print("ext  curr loop read time(s)    mean     median      mode    stddev")
print("     read")
for(i=1;i<=nimset;i+=1){
  imsci=l_im//"["//sciname//","//i//"]"
  hselect(imsci,"loop,read,curr_ndr,time_obs",yes) | scan(loop,read,currndr,timeobs[i])
  timeobs[i]=timeobs[i]/1000
  imsec=imsci//"["//l_sec//"]"
  imstat(imsec,fields="midpt,mode,mean,stddev",lower=INDEF,upper=INDEF,binwidth=0.1,format=no) | scan(smidpt,testmode,smean,sstddev)
## if midpt or mode are INDEF and mean = 0 then set midpt and mode to 0
  imstat(imsec,fields="mode",format-) | scan(smode[i])
  if(smean==0){
    if(smidpt==INDEF)
      smidpt=0
    if(testmode==INDEF)
      testmode=0
##for some reason when smode[i] can be INDEF it decides its value is -1.9922
  smode[i]=testmode
  }

  print(sciname,",",i," ",currndr," ",loop," ",read," ",timeobs[i]," ",smean," ",smidpt," ",smode[i]," ",sstddev)
}

cts=smode[1]-smode[nimset]
endtime=timeobs[1]-timeobs[nimset]
ctssec=cts/endtime

elsec=ctssec*gain

print(cts," DN in ",endtime,"s")
print(ctssec," DN/s")
print(elsec," e/s")

end



