# locatepeaks_sep.cl
#
# iraf wrapper to the c programs peakfind_sep and specmark
#
# Takes a cut through the input image and finds the positions of peaks 
# within the cut, used to identify the calibration fibres in cirpass images,
# only using fibres that are well separated
#
# A. J. Dean., 19th Oct, 2001.

procedure locatepeaks_sep(imagefile, xline, innoise, insigma, outputfile, inminsep)

string imagefile {prompt="Input file"}
int    xline     {512,prompt="Line to use as cut through image"}
real   innoise   {10,prompt="Background noise in image"}
real   insigma   {30,prompt="Sigma above background which constitutes a line"}
string outputfile{prompt="File to write out positions to"}
int    inminsep  {prompt="Minimum separation between fibres"}

begin

 	string imfile, outfile, tempfile
	int line, len, minsep
	real noise, sigma
	
	imfile=imagefile
	line=xline
	noise=innoise
	sigma=insigma
	outfile=outputfile
 	minsep=inminsep

# Load required packages

	utils

# check for .fits on the end

        len=strlen(imfile)
        if(substr(imfile,len-4,len)!=".fits") {
                imfile=imfile//".fits"
        }

	display(imfile//"[sci,1]",1)
	peakfind_sep(imfile,line,noise,sigma,outfile,minsep)
	tempfile=mktemp("__temp__")
	imcopy(imfile//"[sci,1]["//line//",*]",tempfile)
	specmark_no_wav(tempfile//".fits",outfile)

	imdel(temp)

end



