# datamonitor.cl
#
# iraf script to watch for the arrival of new data
# reduce it when it arrives, and copy it over to the 
# backup directory
#
# Andrew J. Dean 17th Dec, 2002

procedure datamonitor()

string monitorfroot {prompt="File name root of the monitor files"}
string monitordir {prompt="Directory where the monitor files will appear"}
string backupdir {prompt="Directory to backup the reduced files to"}
int    firstfnum {prompt="Index of the first monitor file to appear"}
bool   dobackup  {prompt="Backup the files to the Gemini server?"}
string logfile {prompt="Text file recording data file names copied to backup directory"}

struct *in {mode="h"}

begin

string froot, mdir, bdir, filename
string name, run, date, stack, tempstring, redfile, moreredfile
string s_year, s_month, s_day
int year, month, day
string gemininame, geminilock, geminidir
string docirppars[4]
string months[12]
string thehour,junk
string thelogfile
int ithehour
real timeobs

int fnum, len, beg
bool exist, idispinter, dodocirpass, dodotarget, dodoflat, dothebackup

froot=monitorfroot
mdir=monitordir
bdir=backupdir
fnum=firstfnum
dothebackup=dobackup
thelogfile=logfile

months[1]="jan"
months[2]="feb"
months[3]="mar"
months[4]="apr"
months[5]="may"
months[6]="jun"
months[7]="jul"
months[8]="aug"
months[9]="sep"
months[10]="oct"
months[11]="nov"
months[12]="dec"

idispinter=idisplay.interactive
#print("idisplay interactive is ",idispinter)
idisplay.interactive=no

# Check for / on end of directory name, and add one if not there
len=strlen(mdir)
if(substr(mdir,len,len)!="/")
  mdir=mdir//"/"
len=strlen(bdir)
if(substr(bdir,len,len)!="/")
  bdir=bdir//"/"

# keep scan happy
year=0
month=0
day=0

# Find out the time and see if we need to run mktoday
junk="notset"
thehour="notset"
ithehour=0

date | scanf("%s %s %s %s %s %s", junk, junk, junk,
             thehour,junk,junk)
thehour=substr(thehour,1,2)
print(thehour) | scanf("%d",ithehour)

# Stop mktoday after 23:00 just in case someone runs this at 23:59:59
# and procedes to call mktoday for the next day! 
if( (ithehour>=15) && (ithehour<23) ){
	mktoday
}

print("Data monitor running and waiting for input file ",
       monitordir//froot//"."//fnum)

while(yes){

	filename=monitordir//froot//"."//fnum
	exist=access(filename)
	if(exist){
		in=filename
		i=1
		print("Reducing: ",filename)
		while(fscan(in,tempstring)!=EOF){
			if(i==5){
				print("An error has occured while reading")
				print(filename)
				bye
			}
	  		docirppars[i]=tempstring
  			if(tempstring=="stop"){
				idisplay.interactive=idispinter
				firstfnum=firstfnum+1
				delete(filename)
				print("Stop command received, exiting")
				bye
			}
			print(docirppars[i])
  		i+=1
	
		}

		# Figure out what data reduction should be done
		# based on the name of the file
		
		# Default reduction
		dodocirpass=yes
		dodotarget=yes
		dodoflat=no

		if(docirppars[1]=="flat" || 
		   docirppars[1]=="Flat" ||
		   docirppars[1]=="FLAT" ||	
		   docirppars[1]=="dome" ||
		   docirppars[1]=="Dome" ||
	           docirppars[1]=="DOME" ||
		   docirppars[1]=="domeon" ||
                   docirppars[1]=="Domeon" ||
                   docirppars[1]=="DOMEON" || 
 	           docirppars[1]=="domeoff" ||
                   docirppars[1]=="Domeoff" ||
                   docirppars[1]=="DOMEOFF" ||
		   docirppars[1]=="detflat" ||
                   docirppars[1]=="Detflat" ||
                   docirppars[1]=="DETFLAT" ||
		   docirppars[1]=="twilight" ||
		   docirppars[1]=="Twilight" ||
		   docirppars[1]=="TWILIGHT" ||
                   docirppars[1]=="dark" ||
                   docirppars[1]=="Dark" ||
                   docirppars[1]=="DARK" ||
                   docirppars[1]=="metal" ||
                   docirppars[1]=="Metal" ||
                   docirppars[1]=="METAL" ||
		   docirppars[1]=="back" ||
		   docirppars[1]=="Back" ||
		   docirppars[1]=="BACK" ){
			dodocirpass=no
			dodoflat=yes
			dodotarget=no
		}
 
		if(docirppars[1]=="arc" ||
                   docirppars[1]=="Arc" ||
                   docirppars[1]=="ARC" ||
		   docirppars[1]=="argon" ||
		   docirppars[1]=="Argon" ||
		   docirppars[1]=="ARGON" ||
		   docirppars[1]=="calfib" ||
  		   docirppars[1]=="Calfib" ||
  		   docirppars[1]=="CALFIB" ){
			dodocirpass=yes
			dodoflat=no
			dodotarget=no
		}
		
		# Any other name should be run through the default
		# reduction

		if(dodocirpass){
			docirpass(docirppars[1], docirppars[2], docirppars[3],
		          	  docirppars[4],inter+)
		}

		if(dodoflat){
			doflat(docirppars[1], docirppars[2], docirppars[3],
		               docirppars[4])
		}

		## Sort out the PixCel run numbering scheme
        	## eg run 1 is numbered run 0001
        	## run nos should be 1-9999
        	docirppars[2]="000"//docirppars[2]
        	len=strlen(docirppars[2])
        	beg=len-3
        	docirppars[2]=substr(docirppars[2],beg,len)

		# Add in a header keyword containing
		# the original cirpass file name
		redfile=docirppars[1]//"_"//docirppars[2]//"_raw.fits"
		moreredfile=docirppars[1]//"_"//docirppars[2]//"_ima.fits"

		hedit(redfile,fields="CIRPNAME",value=redfile,add+, update+, 
		      ver-,show-)
		hedit(moreredfile,fields="CIRPNAME",value=redfile,add+, 
		      update+,ver-,show-)
	
		# Sort out the INT_TIME keyword, which pixcel
		# writes incorrectly.
		# Use the samptime parameter from an _ima file
		# which will have been filled in by zsub.
		imgets(moreredfile//"[sci,1]", "SAMPTIME")
		timeobs = real(imgets.value)
		timeobs = timeobs / 1000.0
		hedit(redfile, fields="INT_TIME", value=timeobs, add-, 
		      update+, ver-, show-)
		hedit(moreredfile, fields="INT_TIME", value=timeobs, add-, 
		      update+, ver-, show-)
	
		if(dodotarget){
			dotarget(moreredfile, extract="sum", writejpeg+, 
			         inter+)
		}
		
		# Do the Gemini backups
		# Figure out the day / month / year for Gemini files
		s_year=substr(docirppars[3],1,4) 
		print(s_year) | scanf("%d",year)
		#print("year is ",year)
		
		s_month=substr(docirppars[3],5,6)
		print(s_month) | scanf("%d",month)
		#print("month is ",months[month])
		
		s_day=substr(docirppars[3],7,8)
		print(s_day) | scanf("%d",day)
		# Gemini days are the end of the night, CIRPASS days
		# are the start of the night
		day=day+1
		if(day<10){
			s_day="0"//day
		} else {
			s_day=day
		}
		#print("day is ",s_day)
		
		gemininame=year//months[month]//s_day//"_"//docirppars[2]
		geminilock=gemininame//".unlock"
		gemininame=gemininame//".fits"
		geminidir=year//months[month]//s_day//"/"
		#print("Gemini name is ",gemininame)
		#print("Gemini lock is ",geminilock)
		#print("Gemini dir is ",geminidir)

		if(dothebackup){

			print("Creating ",bdir//geminidir//gemininame)
			print("and ",bdir//geminidir//geminilock)

			# Write a list of the files that we've attempted 
			# to backup to a text file 
			print(redfile," ",gemininame,>>thelogfile)

			# Copy over the files
			gemcp(redfile,bdir//geminidir//gemininame)
			gemtouch(bdir//geminidir//geminilock)
		}

		delete(filename)
		fnum+=1
		firstfnum=fnum

		print("Data monitor running and waiting for input file ",
		      monitordir//froot//"."//fnum)

	}

	sleep(5)

}

end





