#
# task copy_imsets.cl, wrapper for c_get_imsets, which copies out
# extensions for a MEF fits file
#
# AJ Dean. 27th March, 2000
#


procedure copy_imsets(infile,outfile,extension)

string infile	 {prompt="Input multi-extension fits file"}
string outfile	 {prompt="Output multi-extension fits file"}
int    extension {prompt="First extension to be copied out"}
int    finext    {0,mode="h",prompt="Final extension to copy out"}
int    step      {1,mode="h",prompt="Step when copying extensions"}

begin

	string inputfile,outputfile, test
	int startext,finalext,stepval, nimset, length

	nimset=cirpasspars.nexn

	print("******* copy imsets ********")
	print("\nWill copy a range of imsets to a new file,")
	print("Give the starting extension for 1 imset only"
	print("For a range: give the final extension and desired step also.")
	print("Things will go horribly wrong if the input and output")
	print("file names are the same!!\n")
	print("****************************")

	inputfile=infile
	outputfile=outfile
	startext=extension
	finalext=finext
	stepval=step

	#load required packages
	utils

	#check for .fits

	length=strlen(inputfile)
	test=substr(inputfile,length-4,length)
	
	if(test!=".fits"){

		inputfile=inputfile//".fits"
		
	}
	
	length=strlen(outputfile)
	test=substr(outputfile,length-4,length)
	
	if(test!=".fits"){

		outputfile=outputfile//".fits"
		
	}
	

	if(finext==0){

		c_get_imsets(inputfile,outputfile,nimset,startext)

	} else {	

		c_get_imsets(inputfile,outputfile,nimset,startext,finalext,stepval)

	}

end



