#include <stdio.h> /* Standard Input/ Output Library */
#include <stdlib.h>
#include <math.h>

#define NBIN 5000

double sigma=1/2.354; //fwhm/2.354

int getgauss(double *gaussval, double _step)
{
  double *gaussval_ptr, term1, term2, term3, pos;

  pos=-5*sigma;
  for(gaussval_ptr=&gaussval[0];gaussval_ptr<&gaussval[NBIN];gaussval_ptr++){
    term1 = 1.0 / (sqrt(2.0*M_PI) * sigma);
    term2 = (0-pos)/ sigma;
    term3 = -0.5 * pow(term2, 2);
    
    *gaussval_ptr=term1 * pow(M_E, term3);
    pos+=_step;
  }
  return 0;
}


int main()
{
  double gaussval[NBIN];
  double step, tot, nlowbin, nhibin, ilow, ihi, fivsig, peakpos;
  int i;

  printf("sigma %g\n",sigma);
  step=(10*sigma)/NBIN;
  fivsig=5*sigma;

  getgauss(gaussval,step);
  
  peakpos=3*sigma;
  
  ilow=peakpos-3*sigma;
  ihi=peakpos+3*sigma;
  
  ilow=ilow-peakpos;
  ihi=ihi-peakpos;
  printf("ilow %g ihi %g\n",ilow,ihi);

  nlowbin=floor(((ilow+fivsig)/step)+0.5);
  nhibin=floor(((ihi+fivsig)/step)+0.5);

  printf("nlowbin %g nhibin %g\n",nlowbin,nhibin);
  for(i=nlowbin;i<nhibin;i++)
    //    printf("i %d gaussval %g\n",i,gaussval[i]);
    tot+=gaussval[i]*step;

  printf("tot %g\n",tot);
  return 0;
}

    
