/* libaddapinfo.c 
 *
 * Program uses the first and last fibre on the detector to update the fits 
 * table extension. The extracted aperture numbers are added which correspond
 * to the lens positions and calibration fibres defined in the table header.
 * A J Dean. 11th June, 2001
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include "apsort.h"
#include "fitswrap.h"
#include "libaddapinfo.h"

extern int libaddapinfo(const char* meffile, int firstfibre, int lastfibre)
{


  int nadd=1;                 /* Number of columns to add to MEF file */
  float** configdata=NULL;    /* Table data read in from MEF file */
  float* coldata[1]={NULL};   /* Table data to output to MEF file */
  float* apnums=NULL;         /* apnums of sorted spectra */
  char* colnames[]={"apnum"}; /* Output table column names */
  char* keywords[2]={NULL};   /* Don't need the header keywords */
  float* keydata[2]={NULL};   /* Don't need the keydata */
  int numhead=0;              /* Don't need the header keywords */
  int numcols;                /* Number of cols + rows in table extension */
  int numrows;
  int pos=2;                  /* Position of table header in MEF file */
  int colposition=0;          /* Position of column in table to be added */
  int i=0;                    /* Loop variable */

  /* Read in the binary table data from the MEF file */
  numhead=0;       /* Don't need the header keywords */
  configdata=read_table(meffile, 2, numhead, keywords, keydata, &numcols, 
			&numrows);
			
  /* Allocate memory for the aperture data */
  if ( ( apnums=(float*)malloc(numrows*sizeof(float)) ) == NULL ){
    printf("addapinfo: Memory allocation failed!");
    exit(1);
  }

  /* Use the first fibre data and the configdata to assign apnums to
   * the spectra
   */ 
  apsort(firstfibre, lastfibre, configdata,apnums,numrows);
  
  coldata[0]=apnums;
  nadd=1;
  colposition=4;

  /* Updata the table extension in the input file */
  if(overwrite_table_column(meffile,pos, colposition, nadd,colnames,coldata,
			    numrows)){
    printf("addapinfo: failed to update the table!");
    exit(1);
  }

  free(apnums);

  for(i=0; i<2; i++){
    free( *(configdata+i) );
  }
  free(configdata); 
  
  return 0;

}




