# tracepeaks.cl
#
# Iraf wrapper to C program peaktrace
#
# A. J. Dean 31st Jan, 2002

procedure tracepeaks(in_imagefile, in_outfile, in_posfile, in_xpos, in_width,
		     in_sigma, in_background)

string in_imagefile {prompt="Image file"}
string in_outfile   {prompt="Output file"}
string in_posfile   {prompt="Positions file"}
int in_xpos         {prompt="Starting line to use on detector"}
int in_width        {prompt="Width around trace to centre over"}
int in_sigma        {prompt="Sigma above background for trace"}
int in_background   {prompt="Background noise in image"}

struct *in {mode="h"}

begin

string imagefile, outfile, posfile, tempout, losttraces
int xpos, width, sigma, background, num
real y, junk
real ydata[550]
real a0,a1,a2,s0,s1,s2


imagefile=in_imagefile 
outfile=in_outfile
posfile=in_posfile
xpos=in_xpos      
width=in_width     
sigma=in_sigma     
background=in_background 

# keep scan happy, lovely iraf feature ...
a0=0
a1=0
a2=0
s0=0
s1=0
s2=0
s3=0

tempout=mktemp("_temp_")
losttraces=mktemp("_losttraces_")

in=posfile
i=1
while(fscan(in,y,junk)!=EOF){
  ydata[i]=y
#  print("i ",i,"found at position ", ydata[i])
  i+=1
  if(i>=550){
	     error(11,"Array for lines found run out of room!")
  }


}

num=i-1

for(i=1; i<=num; i+=1){
	
	peaktrace(imagefile, tempout, xpos, ydata[i], width, sigma, 
		  background,>>losttraces)
	
	polyfit(tempout,2,weighting="uniform",l-) | scan(a0,a1,a2,s0,s1,s2)

#	print("Fibre: ", ydata[i], " Trace = ",a0," + ",a1,"X + ",a2,"X2",
#              >>outfile)

	print(ydata[i], " 1.0 2 ", a0, " ", a1, " ", a2, >>outfile)

	delete(tempout)
	delete(losttraces)

}

end



