#include <stdio.h> /* Standard Input/ Output Library */
#include <stdlib.h>
#include <math.h>
//#include <nrutil.h>

#define MAX(a,b) ((a)>(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))

/* Global variables */
float fwhm=0.2;
double nbin=5000.0;
float pitch=2.03;

double gaussian(double l1, double l0, double delta) 
{
  //fraser's gaussian.c
  
  double term1, term2, term3; 	// As the Equation is quite big.
  
  term1 = 1.0 / (sqrt(2.0*M_PI) * delta);
  term2 = (l1 - l0)/ delta;
  term3 = -0.5 * pow(term2, 2);
  
  return term1 * pow(M_E, term3);
}



double gaussint(double ilow, double ihi, double peakpos)
{

  double sigma=fwhm/2.354;
  double istep=(ihi-ilow)/nbin;
  double i, tot;

  tot=0.0;
  for(i=ilow;i<ihi;i+=istep)
    tot+=gaussian(peakpos,i,sigma)*istep;
  
  //printf("%s %g %s %g %s %g\n","ilow",ilow,"ihi",ihi,"tot",tot);
  return tot;
}

int getval1 (char *filename, double *val, int ppsize)
{
  /*read in doubles from file filename */
  /*CHANGE to read from IRAF database file*/

  int i, numval;
  FILE *infile;

  if ((infile=fopen(filename,"r")) == NULL){
    fprintf(stderr,"Cannot open %s\n", filename);
    exit(-1);
  }

  i=0;
  do {
    fscanf(infile,"%lf",val+i);
    i++;
  } while(!feof(infile)&&i<=ppsize);
  numval=i-1;

  return numval;
}

int getphi ( double *peakpos, int numpk, int numval, double **phi)
{

  double pmin, pmax;
  double ilow, ihi;
  int i,j,pixnum,test;

  printf("%s\n","in getphi");

  //for(i=0;i<numpk;i++) printf("%s %d %s %g\n","i",i,"peakpos",peakpos[i]);

  for(j=0;j<numpk;j++){
    if(j==0){
      pmin=peakpos[j]-pitch;
      //printf("%s %d %s %g\n","j",j,"peakpos",peakpos[j]);
    }
    else{
      pmin=peakpos[j-1];
    }
    if(j==numpk-1){
      pmax=peakpos[j]+pitch;
    }
    else{
      pmax=peakpos[j+1];
    }
    //printf("%s %d %s %g %s %g %s %g\n","j",j,"pmin",pmin,"pmax",pmax,"peak",peakpos[j]);

    test=abs(pmin+0.5);

    for(i=0;i<numval;i++){
      //use i+1 here because these are pixel centres and first pixel is centred at 1
      pixnum=i+1;


      if((pixnum<abs(pmin+0.5))||(pixnum>abs(pmax+0.5))){
	phi[j][i]=0.0;
      }
      else{
	ilow=MAX(pixnum-0.5,pmin);
	ihi=MIN(pixnum+0.5,pmax);

	//	printf("%s %d\n","setphi for",i);
	  
	phi[j][i]=gaussint(ilow,ihi,peakpos[j]);
	//	printf("j %d pixel number %d integrate from ilow %g to ihi %g phi[j][i] %g\n",j,pixnum,ilow,ihi,phi[j][i]);

      }
    }
  }

  return 0;
}

int getdiag(double **phi,double *a, double *b, double *c,double numpk, double numval)
{
  int i,k;

  //get diagonals of tridiagonal matrix

  for(k=0;k<numpk;k++){
    if(k>0){
      for(i=0;i<numval;i++){
	a[k]+=phi[k][i]*phi[k-1][i];
      }
    }
    for(i=0;i<numval;i++){
      b[k]+=phi[k][i]*phi[k][i];
    }
    if(k<numpk){
      for(i=0;i<numval;i++){
	c[k]+=phi[k][i]*phi[k+1][i];
	//if((phi[k][i]>0)&&(phi[k+1][i]>0))
	//printf("%s %d %s %d %s %g %s %g %s %g\n","k",k,"i",i,"phi[k][i]",phi[k][i],"phi[k+1][i]",phi[k+1][i],"c",c[k]);
      }
    }
  }

return 0;
}

int getr(double *pixval, double **phi, double numpk, double numval, double *r)
{
  int i,j;

  for(j=0;j<numpk;j++){
    for(i=0;i<numval;i++){
      r[j]+=pixval[i]*phi[j][i];
      //if(phi[j][i]>0)
      //printf("%s %d %s %d %s %g %s %g %s %g\n","j",j,"i",i,"phi[j][i]",phi[j][i],"pixval[i]",pixval[i],"r[j]",r[j]);
    }
  }

  return 0;
}

int tridiag(double *a, double *b, double *c, double *r, double *u, int numpk)
{
  //numerical recipes p51
  
  double bet,gam[499];
  int j;

  //gam=vector(0,numpk-1);
  if(b[0]==0.0) printf("%s\n","Error 1 in tridag");
  u[0]=r[0]/(bet=b[0]);
  //printf("%s %g %s %g\n","u[0]",u[0],"bet",bet);
  for(j=1;j<numpk;j++){
    gam[j]=c[j-1]/bet;
    //printf("%s %g\n","gam",gam[j]);
    bet=b[j]-a[j]*gam[j];
    //printf("%s %d %s %g %s %g\n","j",j,"gam",gam[j],"bet",bet);
    if(bet==0.0) printf("%s","Error 2 in tridiag");
    u[j]=(r[j]-a[j]*u[j-1])/bet;
    //printf("%s %d %s %g %s %g\n","j", j, "u[j]", u[j], "gam[j]", gam[j]);
  }
  for(j=(numpk-2);j>=0;j--){
    u[j]-=gam[j+1]*u[j+1];
    //printf("%s %d %s %g %s %g %s %g\n","j",j,"gam[j+1]",gam[j+1],"u[j+1]",u[j+1],"u[j]",u[j]);
  }
  //free_vector(gam,0,numpk-1);

  return 0;
}
    
int main ()
{
  int numpk, numval;
  double peakpos[499];
  double pixval[2048];
  double *phi[499];
  double a[499];
  double b[499];
  double c[499];
  double r[499];
  double u[499];
  char filename[255];
  int i, j;

  printf("fwhm is %g\n",fwhm);
  printf("nbin is %g\n",nbin);

  for(i=0;i<499;i++)
    phi[i]=(double*)malloc(2048*sizeof(double));

  sprintf(filename,"peakpos1.list");
  numpk = getval1(filename, peakpos, 499);
  printf("%s %d\n","numpk",numpk);

  //for(i=0;i<numpk;i++) printf("%s %d %s %g\n","i",i,"peakpos",peakpos[i]);
  
  sprintf(filename,"pixval1.list");
  numval = getval1(filename, pixval, 2048);
  printf("%s %d\n","numval",numval);

  //  for(i=0;i<numval;i++) printf("%s %d %g\n","pixval",i,pixval[i]);

  getphi(peakpos, numpk, numval, phi);

  //printf("%s\n","in main phi");
  for(i=0;i<numpk;i++){
    for(j=0;j<numval;j++){
  if(phi[i][j]>0.0)
  printf("i %d j %d phi[i][j] %g\n",i,j,phi[i][j]);
    }
  }

  getdiag(phi,a,b,c,numpk,numval);

  getr(pixval,phi,numpk,numval,r);

  //for(i=0;i<numpk;i+=1){
  //if(r[i]>0)
  //  printf("i %d a %g b %g c %g r %g\n",i,a[i],b[i],c[i],r[i]);
  //}
  //for(i=0;i<numpk;i++) printf("%s %g\n","r",r[i]);

  tridiag(a,b,c,r,u,numpk);

  for(i=0;i<numpk;i++) printf("%s %d %s %g\n","i",i,"sum",u[i]);

  return 0;
}
