# mefmedian.cl
#
# Quick doing the median of a mef file
#
# A. J. Dean. 8th April, 2002

procedure mefmedian(f_infile, f_outfile)

string f_infile {prompt="Input MEF file"}
string f_outfile {prompt="Output MEF file"}
int i_xmed {1, prompt="Number of pixels to median in X direction"}
int i_ymed {30, prompt="Number of pixels to median in Y direction"}

begin

string infile, outfile
int xmed, ymed
string temp1
int len

infile=f_infile
outfile=f_outfile
xmed=i_xmed
ymed=i_ymed

len=strlen(infile)
if(substr(infile,len-4,len)!=".fits") {
         infile=infile//".fits"
}

len=strlen(outfile)
if(substr(outfile,len-4,len)!=".fits") {
         outfile=outfile//".fits"
}

temp1=mktemp("_med2_")

temp1=temp1//".fits"

median(infile//"[sci,1]", temp1, xmed, ymed)

print("Writing ",outfile," MEF file")
makemef(infile,temp1,outfile)


imdelete(temp1)

end


