###############################################################################
# task stack_read                                                             #
# Procedure to create multi-extension FITS files from input FITS file         #
# list.                                                                       #
# The first file in the list is placed into the last extension, the second    #
# file in the next-to-last extension etc.                                     #
# Task stack_read - iraf cl procedure to call the c script which does the     #
# actual stacking                                                             #
#                                                                             #
# Created by A. J. Dean 20th June, 2000                                       #
#                                                                             #
###############################################################################

procedure stack_read(filelist,outfile,configfile)

string filelist {prompt="List of files to stack"}
string outfile {prompt="Output file name"}
string configfile{prompt="Fibre configuration data file (or type nonesense)"}

struct *in

begin

	string ffilelist, foutfile, cfgfile, temp1, tempstr
	int i

	ffilelist = filelist
	foutfile  = outfile
	cfgfile   = configfile

# load required packages

	utils

# read input filelist into a temp file

	temp1=mktemp("temp")
	sections(ffilelist,option="fullname",>>temp1)

	in=temp1

# find out how many files we got
	
	i=0;
	while(fscan(in,tempstr)!=EOF){
		i+=1
	}	


# call the c program

	c_stack(temp1,i,foutfile,cfgfile)

# clean up 

	delete(temp1)

end

