# read_header.cl
#
# iraf script to determine the data reduction pipeline header keywords
# from a cirpass produced mef file and print them to the screen.
# Optionally load the values into dogemini so that they can be edited
# and re-written as required.
#
# A. J. Dean 17th Mar, 2003

procedure read_header(imagename,update)

string imagename {prompt="File name whose headers are to be printed"}
bool update	 {prompt="Write the header entries to task dogemini?"}

begin

string name, namezero
string bkgfile, extrfile
string zoffcorr, cridcalc, bkgcorr, doextr
string zoffdone, criddone, bkgdone, extrdone
bool up_dogem
int len

# Query parameters

name=imagename
up_dogem=update

len=strlen(name)
if(substr(name,len-4,len)!=".fits") {
	name=name//".fits"
}

if(!access(name)){
	error(10,"Cannot access image "//name//" !")
}

namezero=name//"[0]"

# Keep scan happy
bkgfile = "notset" 
extrfile = "notset" 
zoffcorr = "notset" 
cridcal = "notset"
bkgcorr = "notset" 
doextr = "notset" 
zoffdone = "notset" 
criddone = "notset" 
bkgdone = "notset" 
extrdone = "notset"  

# Calibration files

hselect(namezero,"BKGFILE",yes) | scan (bkgfile)
hselect(namezero,"EXTRFILE",yes) | scan (extrfile)


# Data reduction path

hselect(namezero,"ZOFFCORR",yes) | scan (zoffcorr)
hselect(namezero,"CRIDCALC",yes) | scan (cridcalc)
hselect(namezero,"BKGCORR",yes) | scan (bkgcorr)
hselect(namezero,"DOEXTR",yes) | scan (doextr)

# Data reduction history

hselect(namezero,"ZOFFDONE",yes) | scan (zoffdone)
hselect(namezero,"CRIDDONE",yes) | scan (criddone)
hselect(namezero,"BKGDONE",yes) | scan (bkgdone)
hselect(namezero,"EXTRDONE",yes) | scan (extrdone)

# Print out the results

print("\n***** Calibration files *****\n")
print("BKGCORR = ",bkgfile, " ## Background file to be subtracted")
print("EXTRFILE = ",extrfile, " ## Fibre position file")

print("\n***** Data reduction path *****\n")
print("ZOFFCORR = ",zoffcorr, " ## Subtract the bias frame?")
print("CRIDCALC = ",cridcalc, " ## Identify cosmic ray hits?")
print("BKGCORR = ",bkgcorr, " ## Subtract a background observation?")
print("DOEXTR = ",doextr, " ## Extract the spectra?")


print("\n***** Data reduction history *****\n")
print("ZOFFDONE = ",zoffdone, " ## Has the bias frame been subtracted?")
print("CRIDDONE = ",criddone, " ## Have cosmic rays been removed?")
print("BKGDONE = ",bkgdone, " ## Has a background frame been subtracted?")
print("EXTRDONE = ",extrdone, " ## Have the spectra been extracted?")

if(up_dogem){

	dogemini.imagename=name
	dogemini.bkgfile_gem=bkgfile
	dogemini.extrfile_gem=extrfile
	dogemini.zoffcorr_gem=zoffcorr
	dogemini.cridcalc_gem=cridcalc
	dogemini.bkgcorr_gem=bkgcorr
	dogemini.doextr_gem=doextr
}

end

