#############################################################################
#
# task gainmeas
#
# to write out mean and variance for given science extension 
# for each file in list.
# only write out if ct rate in each loop > given min 
#
# RAJ 12.9.00
#############################################################################

procedure gainmeas(imlist,resfile,sec,min)

string imlist{prompt="file containing list of MEF files"}
string resfile{prompt="output file"}
string sec{prompt="section to use to find stats"}
string min{prompt="min ct rate to use"}

begin

string l_imlist,l_sec,l_resfile,filearr[100]
string filename,sciname,varname,dqname,timname,imph,imsci,imsec
int nexn,totexn,nimset,numarr
real rmean[100],rsdev,rvar[100],l_min,diff
bool write

#############query parameters#########################
l_imlist=imlist
l_resfile=resfile
l_sec=sec
l_min=real(min)

############hardwired pars should go in package parameters###################
##hardwired num of extensions per imset
nexn=4
##hardwired header extname for extensions
sciname="SCI"
varname="VAR"
dqname="DQ"
timname="TIME"

###go through file list
list=l_imlist
while(fscan(list,filename)!=EOF){
##new file
##resets
  write=yes
  j=1
  numarr=0
##Can't remember how to reset arrays
#  rmeanarr=[]
#  rvararr=[]

  print(filename)
  imph=filename//"[0]"
##get number of extension in file
  hselect(imph,"nextend","yes") | scan(totexn)
##number of imsets
  nimset=totexn/nex
##go through each imset and read mean and variance from science extension
##into an array
  for(i=1;i<=nimset;i+=1){
    imsci=filename//"["//sciname//","//i//"]"  
    imsec=imsci//"["//l_sec//"]"
    print(imsec)
    imstat(imsec,fields="mean,stddev",format-) | scan(rmean[j],rsdev)
    rvar[j]=rsdev**2
    filearr[j]=imsci
    j+=1
  }
  numarr=j
  print("numarr ",numarr)
##NB arr[1] is the highest counts, array[numarr] the lowest
##check each sample has more counts than min, if not set write=no
##assuming numarr-1 sample has mean=0
  for(j=1;j<numarr-1;j+=1){
    if(j==numarr-2){
      diff=rmean[j]
    }
    else{
      diff=rmean[j]-rmean[j+1]
    }
    if(diff<=l_min)
      write=no
    print(rmean[j],rmean[j+1],diff,write)
  }
##if write=yes then write results from array into file except where mean=0
  if(write){
    for(j=1;j<numarr;j+=1){
      if(rmean[j]!=0)
        print(rmean[j],rvar[j],filearr[j],>>l_resfile)
    }
  }
}


end

