# Scattering .cl -> computes how much light in image sections
#
# A. J. Dean 23rd May, 2002

procedure scattering(in_imagefile,in_secfile)

string in_imagefile {prompt="Image name"}
string in_secfile {prompt="File containing image sections"}

struct *in {mode="h"}

begin

string imagefile, secfile
string section
string secarray[50]
int i, num, sumpix
real mean, npix
real sum
real imtotal, scattered

imagefile=in_imagefile
secfile=in_secfile

in=secfile
i=1
while(fscan(in,section)!=EOF){
	secarray[i]=section
	i+=1
 	if(i>=50){
       	     error(11,"Array for sections run out of room!")
  	}	

}

num=i-1

mean=0
npix=0
imtotal=0
sum=0
sumpix=0

for(i=1; i<=num; i+=1){
	imstat(imagefile//secarray[i], fields="mean,npix",format-) | scan(mean,npix)
#	imstat(imagefile//"[*,"//secarray[i]//"]",fields="mean,npix",format-) | scan(mean,npix)
#	print("Mean and npix are :",mean," ",npix)
	sum=sum+(mean*npix)
	sumpix=sumpix+npix
}

imstat(imagefile,fields="mean,npix",format-) | scan(mean,npix)

imtotal = mean*npix

scattered=(imtotal - sum)*(npix/(npix-sumpix))

print("Total light, scattered, image = ",sum,scattered,imtotal)

print("Percentage scattered = ",(scattered/imtotal)*100)

print("Total pixels with light from source = ",sumpix)
end

